package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "fin_payment_notice_d")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_notice_d", comment = "付款通知明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "付款通知明细表", description = "付款通知明细表")
@Where(clause = "delete_flag = 0")
public class PaymentNoticeDDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;
    /**
     * 收费项目
     */
    @Column(name = "item_code", columnDefinition = "varchar(40) comment '收费项目'")
    private String itemCode;
    /**
     * 税率
     */
    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,6) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,8) comment '含税金额'")
    private BigDecimal amt;

    @Column(name = "is_to_billing", columnDefinition = "varchar(125) comment '是否参与开票'")
    private String isToBilling;

}
