package com.elitesland.fin.infr.dto.saleinv;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售已开发票明细
 */
@Data
public class SaleInvdDtlDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "关联id")
    private Long masId;

    @SysCode(sys = "yst-fin", mod = "INV_RED_BLUE_TYPE")
    @ApiModelProperty("红蓝票类型")
    private String redBlueType;
    private String redBlueTypeName;

    @ApiModelProperty(value = "发票号码")
    private String invNo;

    @ApiModelProperty(value = "发票代码")
    private String invCode;

    @ApiModelProperty(value = "流水号")
    private String flowNo;

    @ApiModelProperty(value = "校验码")
    private String checkCode;

    @ApiModelProperty(value = "原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty(value = "原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty(value = "开票金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty(value = "红冲状态")
    private String redState;

    @ApiModelProperty(value = "红冲失败原因")
    private String redFailCause;

    @ApiModelProperty(value = "开票状态")
    private String invState;

    @ApiModelProperty(value = "pdf链接")
    private String invPdfUrl;

    @ApiModelProperty(value = "开票失败原因")
    private String invFailCause;

    @ApiModelProperty(value = "换开审核状态")
    private String invoiceRedraftState;

}