package com.elitesland.fin.repo.account;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.entity.account.QAccountStorageDO;
import com.elitesland.fin.entity.account.QAccountStorageDetailDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/5/18
 */
@Component
@RequiredArgsConstructor
public class AccountStorageRepoProc {

    private static final QAccountStorageDO qdo = QAccountStorageDO.accountStorageDO;
    private static final QAccountStorageDetailDO dtldo = QAccountStorageDetailDO.accountStorageDetailDO;
    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 分页查询
     * @param query 查询参数
     * @return
     */
    public PagingVO<AccountStorageVO> queryPaging(AccountStorageParam query) {
        JPAQuery<AccountStorageVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<AccountStorageVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<AccountStorageVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<AccountStorageVO> getList(AccountStorageParam query){
        JPAQuery<AccountStorageVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccountStorageVO> getJpaQueryWhere(AccountStorageParam query) {
        JPAQuery<AccountStorageVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getAccCode())) {
            jpaQuery.where(qdo.accCode.eq(query.getAccCode()));
        }
        if (!ObjectUtils.isEmpty(query.getAccName())) {
            jpaQuery.where(qdo.accName.eq(query.getAccName()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiptStatus())) {
            jpaQuery.where(qdo.receiptStatus.eq(query.getReceiptStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiptType())) {
            jpaQuery.where(qdo.receiptType.eq(query.getReceiptType()));
        }
        if (!ObjectUtils.isEmpty(query.getPayMode())) {
            jpaQuery.where(qdo.payMode.eq(query.getPayMode()));
        }
        if (!ObjectUtils.isEmpty(query.getOuName())) {
            jpaQuery.where(qdo.ouName.eq(query.getOuName()));
        }
        if (!ObjectUtils.isEmpty(query.getRemitter())) {
            jpaQuery.where(qdo.remitter.eq(query.getRemitter()));
        }
        if (!ObjectUtils.isEmpty(query.getRemitterAccount())) {
            jpaQuery.where(qdo.remitterAccount.eq(query.getRemitterAccount()));
        }
        if (!ObjectUtils.isEmpty(query.getFranchisee())){
            jpaQuery.where(qdo.franchisee.eq(query.getFranchisee()));
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if(StrUtil.isNotBlank(query.getRemitterTimeStart())){
            LocalDateTime parse = LocalDateTime.parse(query.getRemitterTimeStart(),dateTimeFormatter);
            LocalDate remitterTimeStart = parse.toLocalDate();
            jpaQuery.where(qdo.remitterDate.goe(remitterTimeStart));
        }
        if(StrUtil.isNotBlank(query.getRemitterTimeEnd())){
            LocalDateTime parse = LocalDateTime.parse(query.getRemitterTimeEnd(),dateTimeFormatter);
            LocalDate remitterTimeEnd = parse.toLocalDate();
            jpaQuery.where(qdo.remitterDate.loe(remitterTimeEnd));
        }
        //数据权限
        BusinessSecurityUtil.where(jpaQuery , AccountStorageDO.class);
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccountStorageVO> getJpaQuerySelect() {
        JPAQuery<AccountStorageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(AccountStorageVO.class,
                qdo.id,
                qdo.franchisee,
                qdo.franchiseeName,
                qdo.company,
                qdo.ouName,
                qdo.payOrderId,
                qdo.tenantId,
                qdo.accName,
                qdo.accCode,
                qdo.remitter,
                qdo.remitterDate,
                qdo.remitterAccount,
                qdo.remitterAccountCode,
                qdo.remitterAmt,
                qdo.remitterBankCode,
                qdo.remitterBankName,
                qdo.ouName,
                qdo.receiptType,
                qdo.receiptStatus,
                qdo.oriMsg,
                qdo.payMode,
                qdo.remark,
                qdo.abstractInfo,
                qdo.creator,
                qdo.createUserId,
                qdo.modifyUserId,
                qdo.createTime,
                qdo.modifyTime,
                qdo.deleteFlag,
                qdo.payMessage,
                qdo.secOuCode,
                qdo.secOuName,
                qdo.accountHolderCode,
                qdo.accountHolderName,
                dtldo.refundReason.as("abstractInfo")
        )).from(qdo)
                .where(qdo.deleteFlag.eq(0))
                .leftJoin(dtldo).on(qdo.id.eq(dtldo.storageId));
        return jpaQuery;
    }

    public void updateAccountStorage(SendPayReq sendPayReq){
        JPAUpdateClause jpaUpdateClause=jpaQueryFactory.update(qdo);
        if(StringUtils.isNotEmpty(sendPayReq.getRemitterAccount())){
            jpaUpdateClause.set(qdo.remitterAccount,sendPayReq.getRemitterAccount());
        }

        if(StringUtils.isNotEmpty(sendPayReq.getRemitterBankCode())){
            jpaUpdateClause.set(qdo.remitterBankCode,sendPayReq.getRemitterBankCode());
        }

        if(StringUtils.isNotEmpty(sendPayReq.getRemitterBankName())){
            jpaUpdateClause.set(qdo.remitterBankName,sendPayReq.getRemitterBankName());
        }

        if(StringUtils.isNotEmpty(sendPayReq.getReceiptStatus())){
            jpaUpdateClause.set(qdo.receiptStatus,sendPayReq.getReceiptStatus());
        }

        if(StringUtils.isNotEmpty(sendPayReq.getApplyFile())){
            jpaUpdateClause.set(qdo.applyFile,sendPayReq.getApplyFile());
        }

        jpaUpdateClause.where(qdo.payOrderId.eq(sendPayReq.getPayOrderId()));
        jpaUpdateClause.execute();
    }

}
