package com.elitesland.fin.application.facade.dto.flowrepair;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/26
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "accountFlowRepairHandleDTO",description = "账户流水修复重算处理计算DTO")
public class AccountFlowRepairHandleDTO implements Serializable {
    private static final long serialVersionUID = -2541982833458405210L;

    @ApiModelProperty(value = "流水修复表的ID")
    private Long flowRepairId;

    @ApiModelProperty(value = "流水修复表的流水号")
    private String flowRepairFlowNo;

    @ApiModelProperty(value = "流水表的ID")
    private Long flowId;

    @ApiModelProperty(value = "流水表的流水号")
    private String flowNo;

    @ApiModelProperty(value = "实际金额")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "变动金额")
    private BigDecimal variableAmount;

    @ApiModelProperty(value = "账户类型")
    private String accountType;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty("交易类型")
    private String transactionType;


    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty(value = "重算原因 [UDC]yst-fin:FLOW_RECALCUL_REASON")
    private String recalculationReason;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;
}
