package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "凭证")
public class FinJournalParam extends BaseModelParam {

    @ApiModelProperty("单据编码")
    private String docNum;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("来源系统编码")
    private String systemSourceCode;

    @ApiModelProperty("来源系统名称")
    private String systemSourceName;

    @ApiModelProperty("凭证编码")
    private String voucherTypeCode;

    @ApiModelProperty("凭证类型")
    private String voucherTypeName;

    @ApiModelProperty("核算维度1")
    private String segment1;

    @ApiModelProperty("核算维度2")
    private String segment2;

    @ApiModelProperty("核算维度3")
    private String segment3;

    @ApiModelProperty("核算维度4")
    private String segment4;

    @ApiModelProperty("核算维度5")
    private String segment5;

    @ApiModelProperty("核算维度6")
    private String segment6;

    @ApiModelProperty("核算维度7")
    private String segment7;

    @ApiModelProperty("核算维度8")
    private String segment8;

    @ApiModelProperty("核算维度9")
    private String segment9;

    @ApiModelProperty("核算维度10")
    private String segment10;

    @ApiModelProperty("核算维度11")
    private String segment11;

    @ApiModelProperty("核算维度12")
    private String segment12;

    @ApiModelProperty("核算维度13")
    private String segment13;

    @ApiModelProperty("核算维度14")
    private String segment14;

    @ApiModelProperty("核算维度15")
    private String segment15;

    @ApiModelProperty("核算维度16")
    private String segment16;

    @ApiModelProperty("核算维度17")
    private String segment17;

    @ApiModelProperty("核算维度18")
    private String segment18;

    @ApiModelProperty("借贷方 D/C")
    private String dC;

    @ApiModelProperty("借方金额")
    private BigDecimal debitAmt;

    @ApiModelProperty("贷方金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("本币借方金额")
    private BigDecimal debitCurAmt;

    @ApiModelProperty("本币贷方金额")
    private BigDecimal creditCurAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("总账日期")
    private LocalDateTime glDate;

    @ApiModelProperty("总账日期")
    private LocalDateTime glDateStart;

    @ApiModelProperty("总账日期")
    private LocalDateTime glDateEnd;

    @ApiModelProperty("会计期间")
    private String accountPeriod;

    @ApiModelProperty("账套编码")
    private String sobLedgerCode;

    @ApiModelProperty("账套名称")
    private String sobLedgerName;

    @ApiModelProperty("业务单号")
    private String docNum1;

    @ApiModelProperty("会计引擎ID")
    private Long accountEngineId;

    @ApiModelProperty("会计引擎明细ID")
    private Long accountEngineDetailsId;

    @ApiModelProperty("记账行ID")
    private Long accEngDetDataId;
}
