package com.elitesland.fin.application.service.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocRespVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocSaveVO;

import java.util.List;
import java.util.Optional;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface CreditAccountIocService {

    /**
     * 新增账户事务码数据
     *
     * @param saveVo 新增账户事务码数据
     * @return 新增账户事务码ID
     */
    ApiResult<Long> createOne(CreditAccountIocSaveVO saveVo);

    /**
     * 修改账户事务码数据
     *
     * @param saveVo 修改账户事务码对象
     * @return 账户事务码ID
     */
    ApiResult<Long> update(CreditAccountIocSaveVO saveVo);

    /**
     * 通过账户事务码ID查询单条数据
     *
     * @param id 账户事务码ID
     * @return 单条账户事务码数据
     */
    ApiResult<CreditAccountIocRespVO> findIdOne(Long id);

    /**
     * 通过账户事务码查询单条数据
     *
     * @param code 账户事务码编码
     * @return 单条账户事务码数据
     */
    Optional<CreditAccountIocRespVO> findByCode(String code);

    /**
     * 通过账户事务码集合查询数据
     *
     * @param codeList 账户事务码编码集合
     * @return 账户事务码数据集合
     */
    List<CreditAccountIocRespVO> findByCodeBatch(List<String> codeList);

    /**
     * 分页查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    PagingVO<CreditAccountIocRespVO> search(CreditAccountIocParamVO param);

    /**
     * 根据账户事务码ID批量逻辑删除
     *
     * @param ids 账户事务码ID集合
     * @return 账户事务码ID集合
     */
    ApiResult<String> deleteBatch(List<Long> ids);

    /**
     * 根据入参查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    List<CreditAccountIocRespVO> select(CreditAccountIocParamVO param);

    List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam);
}
