package com.elitesland.fin.domain.entity.saleinv;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Data
public class SaleInvDtl extends BaseModel implements Serializable {


    private Long masId;

    private String taxName;

    private String taxCode;

    private String invNature;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private Long itemId;

    private String itemName;

    private String itemCode;

    private String itemType;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal price;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxRate;

    private BigDecimal taxAmt;

    private BigDecimal taxCurAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal exclTaxCurAmt;

    private String invType;

    private String invKind;

    private String examType;


    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    @ApiModelProperty("发/收货单号")
    private String docNo;

    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    @ApiModelProperty("来源单据明细表ID")
    private Long optDocDtlId;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    private BigDecimal itemDiscount;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("待开发票id")
    private Long invoiceAwaitId;

    public void check() {
        // 商品
        Assert.notEmpty(this.itemCode, "itemCode is null");
        // 单位
        Assert.notEmpty(this.uom, "uom is null");
        // 数量
        Assert.notNull(this.qty, "qty is null");
        //【含税单价】
        Assert.notNull(this.price, "price is null");
        //【含税金额】*显示，计算逻辑计算，置灰；
        Assert.notNull(this.totalAmt, "totalAmt is null");
        //【税率】*显示，根据商品主数据获取销项税率，可修改；
        Assert.notNull(this.taxRate, "taxRate is null");
        //【税额】*显示，计算逻辑计算，置灰；
        Assert.notNull(this.taxAmt, "taxAmt is null");
    }
}