package com.elitesland.fin.domain.param.recorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("收款单返回")
public class RecOrderRpcPageRespVo implements Serializable {
    private static final long serialVersionUID = 8008018197827972546L;
    //门店编号
    @ApiModelProperty("id")
    private Long id;
    //门店编号
    @ApiModelProperty("门店编号")
    private String shopCode;
    //门店名称
    @ApiModelProperty("门店名称")
    private String shopName;
    //主表id
    @ApiModelProperty("主表id")
    private Long masId;
    //业务编号
    @ApiModelProperty("业务编号")
    private String serviceNo;
    //业务类型
    @ApiModelProperty("业务类型")
    private String serviceType;
    @ApiModelProperty("子表id")
    private String dId;
    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;

    @ApiModelProperty("收款单类型代码")
    @SysCode(sys = "yst-fin" ,mod = "REC_TYPE")
    private String recTypeCode;
    private String recTypeCodeName;

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "RECORDER_STATE")
    private String orderState;
    private String orderStateName;
    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDate;
    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-supp" ,mod = "DOC_CLS")
    private String createMode;
    private String createModeName;
    @ApiModelProperty("核销状态")
//    @SysCode(sys = "FIN", mod = "VERIFY_STATUS")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("销售部门编码")
    private String buCode;

    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收款公司ID")
    private Long recOuId;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("销售组织编码")
    private String orgCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售组织ID")
    private Long orgId;

    @ApiModelProperty("销售组织名称")
    private String orgName;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

//    @ApiModelProperty("单据类型")
//    @SysCode(sys = "yst-fin", mod = "RECORDER_TYPE")
//    private String recOrderType;
//    private String recOrderTypeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("创建人")
    private String creatorRec;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("创建人ID")
    private Long createUserIdRec;

    @ApiModelProperty("备注")
    private String remarkRec;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;


//    @ApiModelProperty("修改人")
//    private String updaterRec;
//
//    @ApiModelProperty("修改时间")
//    private LocalDateTime modifyTimeRec;
//
//    @ApiModelProperty("锁版本")
//    private Integer auditDataVersionRec;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;
    @ApiModelProperty("支付凭证")
    private String applyFile;
    @ApiModelProperty("汇款银行编码")
    private String remitterBankCode;
    @ApiModelProperty("汇款银行名称")
    private String remitterBankName;
    @ApiModelProperty("汇款银行账户")
    private String remitterAccount;
    @ApiModelProperty("归属加盟商")
    private String franchisee;
    @ApiModelProperty("归属加盟商名称")
    private String franchiseeName;
    @ApiModelProperty("支付凭证")
    private List<String> applyFileList;
    @ApiModelProperty("明细信息")
    private List<RecOrderDetailSaveParam> dtlList;

    @ApiModelProperty("工作流-流程实例ID")
    private String workflowProcInstId;

    @ApiModelProperty("工作流-流程实例状态")
    private ProcInstStatus workflowProcInstStatus;

    @ApiModelProperty(value = "工作流-提交时间")
    private LocalDateTime workflowSubmitTime;

    @ApiModelProperty(value = "工作流-审批通过时间")
    private LocalDateTime workflowEndTime;

    @ApiModelProperty(value = "工作流-当前审批节点KEY")
    private String workflowCurrentNodeKey;

    @ApiModelProperty(value = "工作流-当前审批节点名称")
    private String workflowCurrentNodeName;

    @ApiModelProperty(value = "工作流-当前节点审批人用户ID（多个使用逗号分隔）")
    private String workflowCurrentUserIds;

    @ApiModelProperty(value = "工作流-审批驳回原因")
    private String workflowRejectedMessage;
}
