package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class FinFlexibleValueServiceImpl implements FinFlexibleValueService{

    private final FinFlexibleValueRepo finFlexibleValueRepo;

    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;

    private final FinFlexibleRepo finFlexibleRepo;
    private final FinSetOfBookService finSetOfBookService;
    private final FinSetOfBookLineService finSetOfBookLineService;

    @SysCodeProc
    @Override
    public PagingVO<FinFlexibleValueVO> page(FinFlexibleValueParam finFlexibleValueParam) {
        if(finFlexibleValueParam.getMasId()==null){
           if(StringUtils.isNotBlank(finFlexibleValueParam.getFlexibleCode())){
               //查询masId
               List<FinFlexibleDO> allByFlexibleCode = finFlexibleRepo.findAllByFlexibleCode(finFlexibleValueParam.getFlexibleCode());
               if(allByFlexibleCode.size()>0){
                   finFlexibleValueParam.setMasId(allByFlexibleCode.get(0).getId());
               }
           }
        }
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }
    @SysCodeProc
    @Override
    public PagingVO<FinFlexibleValueVO> pageBySetOfBook(FinFlexibleValueParam finFlexibleValueParam) {
        if(StringUtils.isBlank(finFlexibleValueParam.getSobCode())){
            throw new BusinessException("账套编码为空");
        }
        if(StringUtils.isBlank(finFlexibleValueParam.getColumnName())){
            throw new BusinessException("核算维度字段名称为空");
        }
        FinSetOfBookDTO finSetOfBookDTO = finSetOfBookService.findBySobCode(finFlexibleValueParam.getSobCode());
        if(finSetOfBookDTO==null){
            throw new BusinessException("未查询到账套");
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = finSetOfBookLineService.findByMasId(finSetOfBookDTO.getId());
        if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
            throw new BusinessException("未查询到账套明细");
        }
        Optional<FinSetOfBookLineDTO> first = finSetOfBookLineDTOList.stream().filter(v -> v.getColumnName().equals(finFlexibleValueParam.getColumnName())).findFirst();
        if(!first.isPresent()){
            throw new BusinessException("未查询到账套明细");
        }
        FinSetOfBookLineDTO finSetOfBookLineDTO = first.get();
        if(!Boolean.TRUE.equals(finSetOfBookLineDTO.getFlexibleFlag())){
            throw new BusinessException("账套明细没有值集标识");
        }
        if (StringUtils.isBlank(finSetOfBookLineDTO.getFlexibleCode())) {
            throw new BusinessException("账套明细值集编码为空");
        }
        finFlexibleValueParam.setFlexibleCode(finSetOfBookLineDTO.getFlexibleCode());
        if(finFlexibleValueParam.getMasId()==null){
            if(StringUtils.isNotBlank(finFlexibleValueParam.getFlexibleCode())){
                //查询masId
                List<FinFlexibleDO> allByFlexibleCode = finFlexibleRepo.findAllByFlexibleCode(finFlexibleValueParam.getFlexibleCode());
                if(allByFlexibleCode.size()>0){
                    finFlexibleValueParam.setMasId(allByFlexibleCode.get(0).getId());
                }
            }
        }
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }
    @Override
    public Map<String, Map<String, FinFlexibleValueVO>> listBySetOfBook(FinFlexibleValueParam finFlexibleValueParam) {
        if(CollectionUtils.isEmpty(finFlexibleValueParam.getSobCodes())){
            return new HashMap<>();
        }
        List<FinSetOfBookDTO> finSetOfBookDTOS = finSetOfBookService.findBySobCodes(finFlexibleValueParam.getSobCodes());
        if(CollectionUtils.isEmpty(finSetOfBookDTOS)){
            return new HashMap<>();
        }
        List<Long> masIds = finSetOfBookDTOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = finSetOfBookLineService.findByMasIds(masIds);
        if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
            return new HashMap<>();
        }
        List<String> flexibleCodes = finSetOfBookLineDTOList.stream().filter(v ->
                        Boolean.TRUE.equals(v.getFlexibleFlag()) && StringUtils.isNotBlank(v.getFlexibleCode()))
                .map(v -> v.getFlexibleCode()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(flexibleCodes)){
            return new HashMap<>();
        }
        //查询masId
        List<FinFlexibleDO> finFlexibleDOS = finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        if(CollectionUtils.isEmpty(finFlexibleDOS)){
            return new HashMap<>();
        }
        List<Long> flexibleIds = finFlexibleDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        finFlexibleValueParam.setMasIds(flexibleIds);
        finFlexibleValueParam.setSize(Integer.MAX_VALUE);
        PagingVO<FinFlexibleValueVO> finFlexibleValueVOPagingVO = FinFlexibleValueConvert.INSTANCE.DTOToVO(finFlexibleValueRepoProc.page(finFlexibleValueParam));
        if(finFlexibleValueVOPagingVO.isEmpty()){
            return new HashMap<>();
        }
        List<FinFlexibleValueVO> finFlexibleValueDOList = finFlexibleValueVOPagingVO.getRecords();
        //
        Map<String, Map<String, FinFlexibleValueVO>> flexCodeValueMap = new HashMap<>();
        Map<String, Long> flexCodeIdMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> v.getId(), (o, n) -> n));
        Map<Long, List<FinFlexibleValueVO>> flexibleValueMap = finFlexibleValueDOList.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        flexCodeValueMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> {
            return flexibleValueMap.get(v.getId()) != null ? flexibleValueMap.get(v.getId()).stream().collect(Collectors.toMap(w -> w.getFlexibleValueCode(), w -> w, (o, n) -> n)) : null;
        }, (o, n) -> n));
        //
        return flexCodeValueMap;
    }
}
