package com.elitesland.fin.application.service.arverconfig;
import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.facade.param.arverconfig.ArVerConfigDtlSaveParam;
import com.elitesland.fin.application.facade.param.arverconfig.ArVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigVO;
import com.elitesland.fin.application.facade.vo.arverconfig.RecAndArOrderVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfig;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.domain.param.arverconfig.OrderParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.arverrec.ArVerRecDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/2 14:37
 */
@Service
@RequiredArgsConstructor
public class ArVerConfigServiceImpl implements ArVerConfigService {

    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    private final ArVerRecDomainService arVerRecDomainService;
    private final ArOrderService arOrderService;
    private final RecOrderService recOrderService;

    @SysCodeProc
    @Override
    public RecAndArOrderVO queryOrderByParam(OrderParam param) {
        if (param.getOuId() == null && StrUtil.isBlank(param.getOuCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "公司信息不能为空!");
        }
        if (param.getCustId() == null && StrUtil.isBlank(param.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "客户信息不能为空!");
        }
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务日期不能为空!");
        }
        RecAndArOrderVO recAndArOrderVO = new RecAndArOrderVO();
        //放置收款单数据
        ArOrderPageParam arOrderPageParam=new ArOrderPageParam();
        arOrderPageParam.setOuId(param.getOuId());
        arOrderPageParam.setOuCode(param.getOuCode());
        arOrderPageParam.setCustId(param.getCustId());
        arOrderPageParam.setCustCode(param.getCustCode());
        arOrderPageParam.setBuDateStart(param.getBuDateStart());
        arOrderPageParam.setBuDateEnd(param.getBuDateEnd());
        arOrderPageParam.setCurrCode(param.getCurrCode());
        arOrderPageParam.setSize(Integer.MAX_VALUE);
        arOrderPageParam.setCurrent(1);
        PagingVO<ArOrderVO> arOrderVOPagingVO = arOrderService.writeoffPage(arOrderPageParam);
        // 应收单列表数据
        recAndArOrderVO.setArOrderVOS(arOrderVOPagingVO.getRecords());
        // 收款单
        RecOrderPageParam recOrderPageParam = new RecOrderPageParam();
        recOrderPageParam.setOuId(param.getOuId());
        recOrderPageParam.setOuCode(param.getOuCode());
        recOrderPageParam.setCustId(param.getCustId());
        recOrderPageParam.setCustCode(param.getCustCode());
        recOrderPageParam.setBuDateStart(param.getBuDateStart());
        recOrderPageParam.setBuDateEnd(param.getBuDateEnd());
        recOrderPageParam.setCurrCode(param.getCurrCode());
        recOrderPageParam.setSize(Integer.MAX_VALUE);
        recOrderPageParam.setCurrent(1);
        PagingVO<RecOrderVO> recOrderVOPagingVO = recOrderService.writeoffPage(recOrderPageParam);
        recAndArOrderVO.setRecOrderVOS(recOrderVOPagingVO.getRecords());
        return recAndArOrderVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<String> save(ArVerConfigSaveParam param) {
        if (param.getId() != null) {
            Map<String, ArVerConfigDtlDTO> dtlMap =
                    arVerConfigDomainService.queryByMasId(param.getId())
                            .stream().collect(Collectors.toMap(ArVerConfigDtlDTO::getFieldNo, t -> t));
            Boolean aBoolean = arVerRecDomainService.queryByScId(param.getId());
            param.getArVerConfigDtlSaveParams().forEach(params -> {
                if (dtlMap.get(params.getFieldNo()) != null) {
                    checkMatchFlag(dtlMap, aBoolean, params);
                }
            });
        }
        ArVerConfig arVerConfig = ArVerConfigConvert.INSTANCE.paramConvert(param);
        String id = arVerConfigDomainService.save(arVerConfig);
        return ApiResult.ok(id);
    }

    private static void checkMatchFlag(Map<String, ArVerConfigDtlDTO> dtlMap, Boolean aBoolean, ArVerConfigDtlSaveParam params) {
        if(!dtlMap.get(params.getFieldNo()).getMatchFlag().equals(params.getMatchFlag()) && aBoolean){
            throw new BusinessException("已被核销记录关联,不允许修改匹配字段!");
        }
    }

    @Override
    @SysCodeProc
    public ApiResult<ArVerConfigVO> queryById(Long id) {
        ArVerConfigDTO arVerConfigDTO = arVerConfigDomainService.queryById(id);
        ArVerConfigVO arVerConfigVO = ArVerConfigConvert.INSTANCE.convertVo(arVerConfigDTO);
        //标记是否允许修改匹配字段
        Boolean aBoolean = arVerRecDomainService.queryByScId(id);
        arVerConfigVO.setFlag(aBoolean);
        return ApiResult.ok(arVerConfigVO);
    }

    @Override
    public ApiResult<ArVerConfigVO> getDef() {
        ArVerConfigDTO arVerConfigDTO = arVerConfigDomainService.queryDef();
        ArVerConfigVO arVerConfigVO = ArVerConfigConvert.INSTANCE.convertVo(arVerConfigDTO);
        if (arVerConfigVO == null) {
            return ApiResult.ok(new ArVerConfigVO());
        }
        return ApiResult.ok(arVerConfigVO);
    }
    @SysCodeProc
    @Override
    public ApiResult<PagingVO<ArVerConfigVO>> page(ArVerConfigPageParam param) {
        PagingVO<ArVerConfigDTO> page = arVerConfigDomainService.page(param);
        PagingVO<ArVerConfigVO> arVerConfigVOPagingVO = ArVerConfigConvert.INSTANCE.convertPage(page);
        return ApiResult.ok(arVerConfigVOPagingVO);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> stop(List<Long> ids) {
        arVerConfigDomainService.updateEnable(ids,false);
        return ApiResult.ok(ids);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> start(List<Long> ids) {
        arVerConfigDomainService.updateEnable(ids,true);
        return ApiResult.ok(ids);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long count = arVerConfigDomainService.updateDef(id);
        return ApiResult.ok(count);
    }

    @Override
    public ApiResult<List<ArVerConfigDtlVO>> queryDtl() {
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = arVerConfigDomainService.queryDtl();
        List<ArVerConfigDtlVO> arVerConfigDtlVOS = ArVerConfigDtlConvert.INSTANCE.convertVo(arVerConfigDtlDTOS);
        return ApiResult.ok(arVerConfigDtlVOS);
    }

    @Override
    public ApiResult<List<ArVerConfigVO>> queryAllConfig() {
        List<ArVerConfigDTO> arVerConfigDTOS = arVerConfigDomainService.queryAll();
        List<ArVerConfigVO> arVerConfigVOS = ArVerConfigConvert.INSTANCE.dtoToVo(arVerConfigDTOS);
        return ApiResult.ok(arVerConfigVOS);
    }
    /**
     * 获取应收单列表数据
     *
     * @param param
     * @return
     */
    private List<ArOrderVO> getArOrderList(OrderParam param) {
        ArOrderParam arOrderParam = new ArOrderParam();
        arOrderParam.setOuId(param.getOuId());
        arOrderParam.setCustId(param.getCustId());
        arOrderParam.setCurrCode(param.getCurrCode());
        arOrderParam.setBuDateStart(param.getBuDateStart());
        arOrderParam.setBuDateEnd(param.getBuDateEnd());
        arOrderParam.setOuCode(param.getOuCode());
        arOrderParam.setCustCode(param.getCustCode());
        List<ArOrderDTO> arOrderList = arOrderDomainService.getArOrderList(arOrderParam);
        List<ArOrderVO> arOrderVOS = ArOrderConvert.INSTANCE.convertList(arOrderList);

        // 过滤剩余未核销金额为0的数据
        List<ArOrderVO> res = arOrderVOS.stream().filter(x -> {
                    x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
                    return x.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
                }
        ).collect(Collectors.toList());
        return res;
    }

    /**
     * 获取收款单数据
     *
     * @param param 查询参数
     * @return 收款单数据
     */
    private List<RecOrderVO> getRecOrderList(OrderParam param) {
        RecOrderParam recOrderParam = new RecOrderParam();
        recOrderParam.setOuId(param.getOuId());
        recOrderParam.setCustId(param.getCustId());
        recOrderParam.setCurrCode(param.getCurrCode());
        recOrderParam.setBuDateStart(param.getBuDateStart());
        recOrderParam.setBuDateEnd(param.getBuDateEnd());
        recOrderParam.setOuCode(param.getOuCode());
        recOrderParam.setCustCode(param.getCustCode());
        //收款单数据
        List<RecOrderDTO> recOrderDTOS = recOrderDomainService.queryByParam(recOrderParam);
        List<RecOrderVO> recOrderVOS = RecOrderConvert.INSTANCE.convertList(recOrderDTOS);
        return recOrderVOS.stream().filter(vo -> {
            vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            //只保留含税金额减去核销金额不为0的数据
            return vo.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
    }

}
