package com.elitesland.fin.application.web.saleinv;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvEmailParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.*;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvAppPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.saleinv
 * @date 2022/5/6 14:32
 */
@RestController
@RequestMapping("/fin/saleInv")
@RequiredArgsConstructor
@Api(tags = {"销售发票列表"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_SALE_INV, businessDoClass = SaleInvDO.class)
@Slf4j
public class SaleInvController {

    public final SaleInvService saleInvService;

    @PostMapping("page")
    @ApiOperation("分页查询销售发票列表")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "销售发票分页",
            businessObjectType = FinBusinessObjectConstant.FIN_SALE_INV,operationCode = FinBusinessObjectConstant.FIN_SALE_INV_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<SaleInvVO>> page(@RequestBody SaleInvPageParam param) {
        PagingVO<SaleInvVO> res = saleInvService.page(param);
        return ApiResult.ok(res);
    }

    @PostMapping("app/page")
    @ApiOperation("小程序我的发票列表")
    public ApiResult<PagingVO<SaleInvAppVO>> page(@RequestBody SaleInvAppPageParam param) {
        PagingVO<SaleInvAppVO> res = saleInvService.appPage(param);
        return ApiResult.ok(res);
    }

    @PostMapping("select/listSum")
    @ApiOperation("查询销售发票列表汇总")
    public ApiResult<SaleInvSumVO> selectListSum(@RequestBody SaleInvPageParam param) {
        SaleInvSumVO saleInvSumVO = saleInvService.selectListSum(param);
        return ApiResult.ok(saleInvSumVO);
    }

    @ApiOperation("获取销售发票详情接口")
    @GetMapping("get")
    public ApiResult<SaleInvVO> get(Long id) {
        SaleInvVO res = saleInvService.get(id);
        return ApiResult.ok(res);
    }

    @ApiOperation("获取销售发票详情接口")
    @GetMapping("app/get")
    public ApiResult<SaleInvAppVO> appGet(Long id) {
        SaleInvAppVO res = saleInvService.appGet(id);
        return ApiResult.ok(res);
    }

    @PostMapping("updateInvInfo")
    @ApiOperation("【列表编辑】更信息表编号，快递单号，备注")
    public ApiResult<Long> updateInvInfo(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.updateInvInfo(saleInvParam);
        return ApiResult.ok(res);
    }

    @GetMapping("dtl/getList")
    @ApiOperation("查询销售明细列表")
    public ApiResult<List<SaleInvDtlVO>> getList(Long masId) {
        List<SaleInvDtlVO> res = saleInvService.getList(masId);
        return ApiResult.ok(res);
    }

    @PostMapping("dtl/getSummaryList")
    @ApiOperation("获取开票明细汇总")
    public ApiResult<List<SaleInvDtlVO>> getSummaryList(@RequestBody List<SaleInvDtlParam> saleInvDtlParamList) {
        List<SaleInvDtlVO> res = saleInvService.getSummaryList(saleInvDtlParamList);
        return ApiResult.ok(res);
    }

    @PostMapping("dtlPage")
    @ApiOperation("查询销售发票明细分页")
    public ApiResult<PagingVO<SaleInvDtlVO>> dtlPage(@RequestBody SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlVO> res = saleInvService.dtlPage(saleInvDtlPageParam);
        return ApiResult.ok(res);
    }

    @GetMapping("dtl/getInvdLists")
    @ApiOperation("查询已开票明细列表")
    public ApiResult<List<SaleInvdDtlVO>> getInvdLists(Long masId) {
        List<SaleInvdDtlVO> res = saleInvService.getInvdLists(masId);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增销售发票")
    public ApiResult<Long> save(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.save(saleInvParam);
        return ApiResult.ok(res);
    }


    @PostMapping("update")
    @ApiOperation("修改销售发票")
    public ApiResult<Long> update(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.update(saleInvParam);
        return ApiResult.ok(res);
    }

    @PostMapping("submit")
    @ApiOperation("销售发票提交")
    public ApiResult<Long> submit(@RequestBody SaleInvParam saleInvParam) {
        Long res = saleInvService.submit(saleInvParam);
        return ApiResult.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除销售发票数据")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        Long res = saleInvService.del(ids);
        return ApiResult.ok(res);
    }

    @PostMapping("/queryAmt")
    @ApiOperation("查询当年红冲金额和当年开票成功金额")
    public ApiResult<SaleInvVO> queryAmt() {
        SaleInvVO res = saleInvService.queryAmt();
        return ApiResult.ok(res);
    }

    @PostMapping("autoCreateArOrder")
    @ApiOperation("金税开票-自动生成应收单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE
            ,operationDescription = "金税开票-自动生成应收单",allowRepeatRequest = false, repeatIntervalMillis = 3000
    )
    public ApiResult<Void> autoCreateArOrder(@RequestBody SaleInvParam saleInvParam) {
        saleInvService.autoCreateArOrder(saleInvParam);
        return ApiResult.ok();
    }

    @PostMapping("sendEmail")
    @ApiOperation("发送邮件")
    public ApiResult<Void> resendEmail(@RequestBody SaleInvEmailParam param) {
        saleInvService.sendEmail(param);
        return ApiResult.ok();
    }
}
