/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDDTO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.ApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceApplyRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.FinIamUtil;
import com.elitesland.order.param.SalDoDQueryRespDTO;
import com.elitesland.order.param.SalDoQueryReqDTO;
import com.elitesland.order.param.SalDoQueryRespDTO;
import com.elitesland.order.param.SalReconciliatQueryDTO;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.order.param.SaleReconciliatDtlDTO;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustRespDTO;
import com.elitesland.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.xxl.job.core.log.XxlJobLogger;
import io.seata.common.util.CollectionUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class InvoiceAwaitServiceImpl
implements InvoiceAwaitService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitServiceImpl.class);
    private static final int SPLIT_LIMIT = 1000;
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final InvoiceAwaitDRepoProc invoiceAwaitDRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService orgRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final TransactionTemplate transactionTemplate;
    private final InvoiceRuleConfigDomainService ruleConfigDomainService;
    private final SystemRpcService systemRpcService;
    private final InvoiceApplyRepoProc invoiceApplyRepoProc;
    private final RmiOrderRpcService rmiOrderRpcService;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final SysNumberGenerator sysNumberGenerator;
    private final SaleInvDomainService saleInvDomainService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final UdcProvider udcProvider;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;
    private final SalDoRpcService salDoRpcService;
    private final CrmCustRpcService crmCustRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final FlexFieldUtilService flexFieldUtilService;
    @Lazy
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {
        PagingVO<InvoiceAwaitDTO> pagingDto = this.invoiceAwaitRepoProc.queryInvoiceAwait(param);
        if (CollectionUtil.isEmpty((Collection)pagingDto.getRecords())) {
            return PagingVO.builder();
        }
        List<Long> masIds = pagingDto.stream().map(InvoiceAwaitDTO::getId).collect(Collectors.toList());
        List<InvoiceAwaitDDO> dtlDos = this.invoiceAwaitDRepo.findAllByMasIdIn(masIds);
        Map<Long, List<InvoiceAwaitDDO>> map = dtlDos.stream().collect(Collectors.groupingBy(InvoiceAwaitDDO::getMasId));
        ArrayList<InvoiceRuleConfigQueryParam> paramList = new ArrayList<InvoiceRuleConfigQueryParam>();
        ArrayList<ApplyInvoiceParam> custParamList = new ArrayList<ApplyInvoiceParam>();
        pagingDto.stream().forEach(dto -> {
            InvoiceRuleConfigQueryParam queryParam = new InvoiceRuleConfigQueryParam();
            queryParam.setOptDocCls(dto.getOptDocCls());
            queryParam.setOptDocType(dto.getOptDocType());
            queryParam.setOptDocStatus(dto.getOptDocStatus());
            paramList.add(queryParam);
            ApplyInvoiceParam custParam = new ApplyInvoiceParam();
            custParam.setCustCode(dto.getMainCustCode());
            custParamList.add(custParam);
        });
        List<InvoiceRuleConfigDTO> ruleConfigList = this.ruleConfigDomainService.getRuleConfigList(paramList);
        Map<String, InvoiceRuleConfigDTO> ruleMap = ruleConfigList.stream().collect(Collectors.toMap(rule -> rule.getOptDocCls() + "_" + rule.getOptDocType() + "_" + rule.getOptDocStatus(), t -> t, (t1, t2) -> t1));
        List<Object> invoiceCustVOS = new ArrayList();
        try {
            invoiceCustVOS = this.invQuery(custParamList);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage());
        }
        Map<String, InvoiceCustVO> custVOMap = invoiceCustVOS.stream().collect(Collectors.toMap(InvoiceCustVO::getCustCode, t -> t, (t1, t2) -> t1));
        Map orderType3 = this.udcProvider.getValueMapByUdcCode("yst-order", "ORDER_TYPE3");
        pagingDto.stream().forEach(item -> {
            List ddos = (List)map.get(item.getId());
            item.setCustId(((InvoiceAwaitDDO)ddos.get(0)).getCustId());
            item.setCustCode(((InvoiceAwaitDDO)ddos.get(0)).getCustCode());
            String custName = ((InvoiceAwaitDDO)ddos.get(0)).getCustName();
            if (ddos.size() > 1) {
                item.setCustName(custName + "\u7b49");
            } else {
                item.setCustName(custName);
            }
            item.setEditInvTitle(0);
            if (ruleMap.containsKey(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus())) {
                Integer editInvTitle = ((InvoiceRuleConfigDTO)((Object)((Object)ruleMap.get(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus())))).getEditInvTitle();
                item.setEditInvTitle(editInvTitle == null ? 0 : editInvTitle);
            }
            if (custVOMap.containsKey(item.getMainCustCode())) {
                item.setEs3(StrUtil.equals((CharSequence)((InvoiceCustVO)custVOMap.get(item.getMainCustCode())).getEs3(), (CharSequence)"1") ? "1" : "0");
            }
            if (StrUtil.equals((CharSequence)item.getEs3(), (CharSequence)"1") && ObjectUtil.equals((Object)item.getEditInvTitle(), (Object)1)) {
                item.setEditInvTitle(1);
            } else {
                item.setEditInvTitle(0);
            }
            item.setDocType3Name((String)orderType3.get(item.getDocType3()));
        });
        PagingVO<InvoiceAwaitVO> invoiceAwaitVOPagingVO = InvoiceAwaitConvert.INSTANCE.pagingDto2Vo(pagingDto);
        if (CollectionUtil.isNotEmpty((Collection)invoiceAwaitVOPagingVO.getRecords())) {
            this.flexFieldUtilService.handleFlexFieldShowNameForVO("INVOICE_AWAIT", invoiceAwaitVOPagingVO.getRecords());
        }
        return invoiceAwaitVOPagingVO;
    }

    @Override
    @SysCodeProc
    public List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId) {
        List<InvoiceAwaitDDO> list = this.invoiceAwaitDRepo.findAllByMasId(masId);
        return InvoiceAwaitDConvert.INSTANCE.dos2Vos(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceSaveVO> invoiceApply(InvoiceApplyParam param) {
        return this.abstractInvoiceSaveService.save(param);
    }

    @Override
    public List<InvoiceApplySaveParam> getInvoiceApplySaveParams(List<InvoiceAwaitRespVO> records, InvoiceApplyParam param) {
        Set<String> optDocClsSet = records.stream().map(InvoiceAwaitRespVO::getOptDocCls).collect(Collectors.toSet());
        List<InvoiceRuleConfigDTO> configDTOList = this.getInvoiceRuleConfigDTOS(optDocClsSet);
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = this.groupByDocCls(records, configDTOList);
        ArrayList<InvoiceApplySaveParam> saveParams = new ArrayList<InvoiceApplySaveParam>();
        optDocClsMap.forEach((key, invoiceAwaitRespVOList) -> {
            List<InvoiceApplySaveParam> saveParam = this.getInvoiceApplySaveParam((List<InvoiceAwaitRespVO>)invoiceAwaitRespVOList, param);
            saveParams.addAll(saveParam);
        });
        return saveParams;
    }

    @Override
    public Map<String, List<InvoiceAwaitRespVO>> groupByDocCls(List<InvoiceAwaitRespVO> records, List<InvoiceRuleConfigDTO> configDTOList) {
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = records.stream().collect(Collectors.groupingBy(InvoiceAwaitRespVO::getOptDocCls));
        if (CollectionUtil.isEmpty(configDTOList)) {
            optDocClsMap.forEach((key, value) -> value.forEach(vo -> vo.setAutoReview(Boolean.FALSE)));
        } else {
            configDTOList.forEach(config -> {
                if (ObjUtil.equals((Object)config.getAutoReview(), (Object)0)) {
                    List voList = (List)optDocClsMap.get(config.getOptDocCls());
                    voList.forEach(vo -> vo.setAutoReview(Boolean.FALSE));
                }
            });
        }
        return optDocClsMap;
    }

    private List<InvoiceRuleConfigDTO> getInvoiceRuleConfigDTOS(Set<String> optDocClsSet) {
        ArrayList<InvoiceRuleConfigQueryParam> queryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        optDocClsSet.forEach(cls -> {
            InvoiceRuleConfigQueryParam configQueryParam = new InvoiceRuleConfigQueryParam();
            configQueryParam.setOptDocCls((String)cls);
            queryParamList.add(configQueryParam);
        });
        return this.ruleConfigDomainService.getRuleConfigList(queryParamList);
    }

    @Override
    public List<InvoiceAwaitRespVO> checkAndQueryInvoiceAwait(InvoiceApplyParam param) {
        Assert.notNull((Object)param.getCustInvTitle(), (String)"\u5f00\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(param.getIds(), (String)"\u6ca1\u6709\u9009\u62e9\u5f85\u5f00\u53d1\u7968", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getInvType(), (String)"\u6ca1\u6709\u9009\u62e9\u53d1\u7968\u7c7b\u578b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getInvTitleType(), (String)"\u6ca1\u6709\u9009\u62e9\u53d1\u7968\u62ac\u5934\u7c7b\u578b", (Object[])new Object[0]);
        List<InvoiceAwaitRespVO> records = this.invoiceAwaitRepoProc.findByIds(param.getIds());
        Assert.notEmpty(records, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f85\u5f00\u7968\u4fe1\u606f", (Object[])new Object[0]);
        Set custCodeSet = records.stream().map(InvoiceAwaitRespVO::getMainCustCode).collect(Collectors.toSet());
        Assert.isTrue((custCodeSet.size() == 1 ? 1 : 0) != 0, (String)"\u6240\u9009\u5f85\u5f00\u53d1\u7968\u6240\u5c5e\u4e3b\u5ba2\u6237\u4fe1\u606f\u4e0d\u552f\u4e00", (Object[])new Object[0]);
        List awaitDOS = this.invoiceAwaitRepo.findAllById(param.getIds());
        awaitDOS.forEach(await -> Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)await.getInvoiceAwaitStatus(), (CharSequence[])new CharSequence[]{UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode(), UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode()}), (String)"\u53ea\u80fd\u9009\u62e9\u72b6\u6001\u4e3a\u5f85\u5f00\u7968\u6216\u8005\u7ea2\u51b2\u5b8c\u6210\u7684\u5355\u636e", (Object[])new Object[0]));
        records = records.stream().peek(record -> record.setInvoiceType(param.getInvType())).toList();
        return records;
    }

    public void setInvoice(InvoiceApplySaveParam saveParam, ApplySaveParam invoice) {
        saveParam.setCustTaxNo(invoice.getCustTaxNo());
        saveParam.setCustInvTitle(invoice.getCustInvTitle());
        saveParam.setCustAdd(invoice.getAddress());
        saveParam.setCustBank(invoice.getCustBank());
        saveParam.setCustBankAcc(invoice.getCustBankAcc());
        saveParam.setCustTel(invoice.getCustTel());
        saveParam.setInvType(invoice.getInvType());
    }

    private List<InvoiceApplySaveParam> getInvoiceApplySaveParam(List<InvoiceAwaitRespVO> recordsP, InvoiceApplyParam param) {
        ArrayList<InvoiceApplySaveParam> saveParams = new ArrayList<InvoiceApplySaveParam>();
        ArrayList<List<Object>> records2 = new ArrayList<List<Object>>();
        if (recordsP.size() > 1000) {
            Map<String, List<InvoiceAwaitRespVO>> awaitRespMap = recordsP.stream().collect(Collectors.groupingBy(InvoiceAwaitRespVO::getRelateDocNo));
            int count = 0;
            ArrayList<InvoiceAwaitRespVO> currentList = new ArrayList<InvoiceAwaitRespVO>();
            for (Map.Entry<String, List<InvoiceAwaitRespVO>> entry : awaitRespMap.entrySet()) {
                List<InvoiceAwaitRespVO> value = entry.getValue();
                if (count + value.size() > 1000) {
                    if (!currentList.isEmpty()) {
                        records2.add(currentList);
                        currentList = new ArrayList();
                        count = 0;
                    }
                    if (value.size() > 1000) {
                        for (int i = 0; i < value.size(); i += 1000) {
                            int endIndex = Math.min(i + 1000, value.size());
                            records2.add(value.subList(i, endIndex));
                        }
                        count = 0;
                        continue;
                    }
                    currentList.addAll(value);
                    count += value.size();
                    continue;
                }
                currentList.addAll(value);
                count += value.size();
            }
            if (!currentList.isEmpty()) {
                records2.add(currentList);
            }
        } else {
            records2.add(recordsP);
        }
        if (CollectionUtil.isNotEmpty(records2)) {
            records2.forEach(records -> {
                InvoiceAwaitRespVO record = (InvoiceAwaitRespVO)records.get(0);
                InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
                saveParam.setInvoiceId(record.getMasId());
                saveParam.setSourceSysNo(record.getOptDocNo());
                saveParam.setOptDocId(record.getOptDocId());
                this.setSaleCompanyInfo(record, saveParam);
                this.setCustInfo(record, saveParam);
                saveParam.setExchangeRate(record.getCurrRate());
                saveParam.setInvUser(FinIamUtil.currentUserName());
                saveParam.setRecUser(FinIamUtil.currentUserName());
                saveParam.setRevUser(FinIamUtil.currentUserName());
                saveParam.setInvMerge("1");
                BigDecimal total = records.stream().map(InvoiceAwaitRespVO::getInvAmt).filter(ObjectUtil::isNotNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                saveParam.setTotalAmt(total);
                saveParam.setInvType(record.getInvoiceType());
                saveParam.setCreateMode(record.getOptDocCls());
                saveParam.setPkGroup(record.getPkGroup());
                saveParam.setSettlementType(record.getSettlementType());
                saveParam.setOpenInvType(record.getOpenInvType());
                saveParam.setDocType3("store_demand_order");
                String applyNo = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "XXFP", new ArrayList<String>());
                saveParam.setApplyNo(applyNo);
                record.setInvoiceApplyNo(applyNo);
                saveParam.setCustBank(record.getPayBank());
                saveParam.setCustBankAcc(record.getPayAccount());
                saveParam.setSaleBank(record.getInvBankName());
                saveParam.setSaleBankAcc(record.getInvBankAcc());
                saveParam.setCustTel(record.getInvTel());
                saveParam.setCustAdd(record.getInvAddress());
                saveParam.setInvTitleType(Strings.isBlank((String)param.getInvTitleType()) ? record.getInvTitleType() : param.getInvTitleType());
                saveParam.setInvPicName(record.getInvPicName());
                saveParam.setInvPicPhone(record.getInvPicPhone());
                saveParam.setInvEmail(record.getInvEmail());
                saveParam.setRecApplyTime(record.getRecApplyTime());
                saveParam.setInvType(Strings.isBlank((String)param.getInvType()) ? record.getInvType() : param.getInvType());
                saveParam.setRemark(param.getRemark());
                saveParam.setInvCustCode(param.getInvCustCode());
                saveParam.setInvCustName(param.getInvCustName());
                saveParam.setInvCustId(param.getInvCustId());
                saveParam.setCustInvTitle(Strings.isBlank((String)param.getCustInvTitle()) ? record.getInvTitle() : param.getCustInvTitle());
                saveParam.setCustTaxNo(Strings.isBlank((String)param.getCustTaxNo()) ? record.getTaxerNo() : param.getCustTaxNo());
                List<InvoiceDetailSaveParam> details = this.getInvoiceDetails((List<InvoiceAwaitRespVO>)records);
                saveParam.setDetails(details);
                saveParams.add(saveParam);
            });
        }
        return saveParams;
    }

    @NotNull
    private List<InvoiceDetailSaveParam> getInvoiceDetails(List<InvoiceAwaitRespVO> records) {
        ArrayList<InvoiceDetailSaveParam> details = new ArrayList<InvoiceDetailSaveParam>();
        for (int i = 0; i < records.size(); ++i) {
            InvoiceAwaitRespVO row = records.get(i);
            InvoiceDetailSaveParam detail = InvoiceAwaitDConvert.INSTANCE.awaitVo2InvoiceParam(row);
            detail.setInvoiceAwaitId(row.getMasId());
            detail.setLineNo(Integer.valueOf(i + 1));
            detail.setSourceId(row.getRelateDocDid());
            detail.setSourceNo(row.getRelateDocNo());
            detail.setSourceTime(row.getRelateDocTime());
            detail.setSourceLine(row.getLineNo());
            detail.setSourceLineId(row.getId());
            detail.setInvNature("\u9ed8\u8ba4\u901a\u7528\u5355");
            detail.setItemCode(row.getItemCode());
            detail.setItemName(row.getItemName());
            detail.setTaxCode(row.getTaxType());
            detail.setTaxName(row.getServiceName());
            detail.setItemType(row.getItemSpec());
            detail.setUom(row.getUom());
            detail.setUomName(row.getUomName());
            detail.setQty(row.getQty());
            detail.setPrice(row.getMainPrice());
            detail.setTotalAmt(row.getAmt());
            detail.setTaxRate(row.getTaxRate());
            detail.setExclTaxAmt(row.getNetAmt());
            detail.setTaxAmt(row.getTax());
            detail.setSourceNo(row.getRelateDocNo());
            detail.setDocNo(row.getRelateDocNo());
            detail.setCustId(row.getDtlCustId());
            detail.setCustName(row.getDtlCustName());
            detail.setCustCode(row.getDtlCustCode());
            detail.setRootDocId(row.getRootDocId());
            detail.setRootDocNo(row.getRootDocNo());
            detail.setRootDocTime(row.getRootDocTime());
            detail.setRootDocDId(row.getRootDocDId());
            details.add(detail);
        }
        return details;
    }

    private void setCustInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {
        saveParam.setCustId(record.getCustId());
        saveParam.setCustCode(record.getCustCode());
        saveParam.setCustName(record.getCustName());
        ApplyInvoiceParam param = new ApplyInvoiceParam();
        param.setCustCode(record.getMainCustCode());
        List<InvoiceCustVO> custVOS = this.invQuery(List.of(param));
        if (CollectionUtil.isNotEmpty(custVOS)) {
            InvoiceCustVO invoiceCustVO = custVOS.get(0);
            saveParam.setCustInvTitle(invoiceCustVO.getInvTitle());
            saveParam.setCustTaxNo(invoiceCustVO.getTaxNo());
            saveParam.setCustAdd(invoiceCustVO.getInvAddress());
            saveParam.setCustTel(invoiceCustVO.getInvTel());
            saveParam.setCustBankAcc(invoiceCustVO.getInvBankAcc());
            saveParam.setCustBank(invoiceCustVO.getInvBankName());
            saveParam.setCustName(invoiceCustVO.getCustName());
        }
    }

    private void setSaleCompanyInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(List.of(record.getOuId()));
        orgOuRpcDtoParam.setOuCodes(List.of(record.getOuCode()));
        List<OrgOuRpcDTO> ouRpcDTOS = this.orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Assert.notEmpty(ouRpcDTOS, (String)"\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a,\u516c\u53f8\u7f16\u7801:{}", (Object[])new Object[]{record.getOuCode()});
        OrgOuRpcDTO ouRpcDTO = ouRpcDTOS.get(0);
        saveParam.setAutoReview(record.getAutoReview());
        saveParam.setOuId(record.getOuId());
        saveParam.setOuCode(record.getOuCode());
        saveParam.setOuName(record.getOuName());
        saveParam.setSourceSysNo(record.getOptDocNo());
        saveParam.setMainCustCode(record.getMainCustCode());
        saveParam.setMainCustId(record.getMainCustId());
        saveParam.setMainCustName(record.getMainCustName());
        saveParam.setSaleTaxNo(ouRpcDTO.getTaxRegNo());
        saveParam.setSaleInvTitle(ouRpcDTO.getInvTitle());
        saveParam.setSaleAdd(ouRpcDTO.getInvAddress());
        saveParam.setSaleBank(ouRpcDTO.getInvBankName());
        saveParam.setSaleBankAcc(ouRpcDTO.getInvBankAcc());
        saveParam.setSaleTel(ouRpcDTO.getInvPicPhone());
        saveParam.setCurrCode(ouRpcDTO.getOuCurr());
        SysCurrencyRespDTO currByCode = this.systemRpcService.findCurrByCode(ouRpcDTO.getOuCurr());
        saveParam.setCurrName(currByCode.getCurrName());
        saveParam.setLocalCurrCode(ouRpcDTO.getOuCurr());
        saveParam.setLocalCurrName(currByCode.getCurrName());
    }

    public InvoiceApplyDTO saveAndSubmitInvoice(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        if (ObjUtil.notEqual((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        saleInv.check();
        saleInv.checkDtl();
        log.info("[YST-FIN] saleInv: {}", (Object)saleInv);
        this.transactionTemplate.setPropagationBehavior(3);
        SaleInvDO execute = (SaleInvDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
                log.info("[YST-FIN] convertDO: {}", (Object)convertDO);
                this.flexFieldUtilService.handFlexFieldValueFeference("SALE_INV", (Object)convertDO);
                SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(convertDO);
                this.saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
                List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
                List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
                log.info("[YST-FIN] convert details: {}", details);
                details.forEach(row -> {
                    row.setMasId(save.getId());
                    this.saleInvDtlRepo.save(row);
                });
                return save;
            }
            catch (Exception e) {
                log.error("\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u51fa\u9519:{}", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, "\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u4fdd\u5b58\u65f6\u51fa\u9519");
            }
        });
        Set<Long> awaitId = param.getDetails().stream().map(item -> item.getInvoiceAwaitId()).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ObjUtil.equals((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            this.workFlow(execute);
        } else {
            this.sendMessage(execute);
        }
        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(execute.getId());
        result.setApplyNo(execute.getApplyNo());
        result.setInvoiceAwaitIds(awaitId);
        return result;
    }

    private void sendMessage(SaleInvDO saleInvDO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDO.getId());
        messageDTO.setCode(saleInvDO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        try {
            this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            throw new BusinessException("\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25");
        }
    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        if (saleInvDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            String procInstName = "\u5f00\u7968\u7533\u8bf7(" + applyNo + ")\u5ba1\u6279";
            String businessKey = "" + saleInvDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_SALE_INV.name(), procInstName, businessKey, new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, saleInvDO.getId());
            log.info("\u5f85\u5f00\u53d1\u7968\u7533\u8bf7\u8d70\u5de5\u4f5c\u6d41,\u7533\u8bf7\u9500\u552e\u53d1\u7968\u5355\u53f7 {}, \u5de5\u4f5c\u6d41\u8fd4\u56de {}", (Object)applyNo, (Object)processInfo);
        }
    }

    @Override
    public List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam) {
        Assert.notEmpty(applyInvoiceParam, (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<String> collect = applyInvoiceParam.stream().map(param -> param.getCustCode()).collect(Collectors.toList());
        List<LmSaveCustRespVO> invCust = this.rmiSaleRpcService.findInvCust(collect);
        return InvoiceAwaitConvert.INSTANCE.custVos2Dtos(invCust);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceAwaitDTO> generateAwaitOrderAndInvoice(String param) {
        List<SaleReconciliatDTO> saleReconciliatDTOS;
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocCls(UdcEnum.DOC_CLS_SACCK.getValueCode());
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = this.invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if (CollectionUtil.isEmpty(ruleConfigDTOList)) {
            log.info("\u672a\u914d\u7f6e\u5f00\u7968\u8bbe\u7f6e\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968");
            XxlJobLogger.log((String)"\u672a\u914d\u7f6e\u5f00\u7968\u8bbe\u7f6e\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968", (Object[])new Object[0]);
            return null;
        }
        SalReconciliatQueryDTO dto = this.buildSaleRecParam(param);
        try {
            log.info("\u67e5\u8be2\u5bf9\u8d26\u5355\u53c2\u6570\uff1a{}", (Object)dto);
            saleReconciliatDTOS = this.rmiOrderRpcService.querySalReconciliat(dto);
            log.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u5230\u7684\u6570\u636e\u7ed3\u679c\uff1a{} ", (Object)JSONUtil.toJsonStr(saleReconciliatDTOS));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5bf9\u8d26\u5355\u63a5\u53e3\u51fa\u9519,\u8bf7\u6c42\u53c2\u6570:{}, \u62a5\u9519\u4fe1\u606f\uff1a{}  ", (Object)dto, (Object)e.getMessage());
            return null;
        }
        if (CollectionUtil.isEmpty(saleReconciliatDTOS)) {
            return null;
        }
        List<SaleReconciliatDTO> collect = saleReconciliatDTOS.stream().filter(item -> CollectionUtil.isNotEmpty((Collection)item.getSaleReconciliatDtlDTOList())).collect(Collectors.toList());
        List<InvoiceAwaitDTO> dtos = this.buildSalRecToInvoiceAwaitOrder(collect);
        ArrayList<Long> list = new ArrayList<Long>();
        log.info("\u4fdd\u5b58\u5f85\u5f00\u7968\u7533\u8bf7\uff1a{}", (Object)JSONUtil.toJsonStr(dtos));
        final ArrayList invoiceAwaitDOList = new ArrayList();
        dtos.forEach(item -> {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
            InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do((InvoiceAwaitDTO)item);
            awaitDO.setDocNo(docNo);
            this.flexFieldUtilService.handFlexFieldValueFeference("INVOICE_AWAIT", (Object)awaitDO);
            InvoiceAwaitDO save = (InvoiceAwaitDO)this.invoiceAwaitRepo.save(awaitDO);
            List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
            dtlList.forEach(dtl -> {
                InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do((InvoiceAwaitDDTO)dtl);
                dtlDo.setMasId(save.getId());
                this.invoiceAwaitDRepo.save(dtlDo);
                list.add(dtl.getOptDocDtlId());
            });
            invoiceAwaitDOList.add(save);
        });
        this.updateTransState(list);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                invoiceAwaitDOList.forEach(save -> {
                    InvoiceApplyParam applyParam = InvoiceAwaitServiceImpl.this.getInvoiceApplyParamByAwaitOrder((InvoiceAwaitDO)save);
                    log.info("\u751f\u6210\u5f00\u7968\u7533\u8bf7\uff1a{}", (Object)JSONUtil.toJsonStr((Object)applyParam));
                    InvoiceAwaitServiceImpl.this.abstractInvoiceSaveService.save(applyParam);
                });
            }
        });
        return dtos;
    }

    private void updateTransState(List<Long> list) {
        List collect = list.stream().filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            SalReconciliatQueryDTO updateDto = new SalReconciliatQueryDTO();
            updateDto.setDtlIds(list);
            try {
                this.rmiOrderRpcService.updateTransState(updateDto);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5bf9\u8d26\u5355\u660e\u7ec6\u4f20\u8f93\u72b6\u6001\u5931\u8d25\uff0c\u53c2\u6570: {}\uff0c\u5931\u8d25\u4fe1\u606f: {}\uff0c", (Object)updateDto, (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<InvoiceAwaitDTO> buildSalRecToInvoiceAwaitOrder(List<SaleReconciliatDTO> saleReconciliatDTOS) {
        ArrayList<InvoiceAwaitDTO> invoiceAwaitDTOS = new ArrayList<InvoiceAwaitDTO>();
        saleReconciliatDTOS.forEach(saleRec -> {
            if (!this.invoiceAwaitRepo.existsByOptDocId(saleRec.getId())) {
                InvoiceAwaitDTO invoiceAwaitDTO = InvoiceAwaitConvert.INSTANCE.sale2AwaitDto((SaleReconciliatDTO)saleRec);
                List<InvoiceAwaitDDTO> dtlList = this.buildSalRecDtl2InvoiceAwaitDtl(saleRec.getSaleReconciliatDtlDTOList());
                invoiceAwaitDTO.setInvoiceAwaitDDTOList(dtlList);
                BigDecimal totalInvAmt = dtlList.stream().map(InvoiceAwaitDDTO::getInvAmt).filter(ObjectUtil::isNotNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoiceAwaitDTO.setAmt(totalInvAmt);
                invoiceAwaitDTO.setId(null);
                invoiceAwaitDTO.setOptDocId(saleRec.getId());
                invoiceAwaitDTO.setOptDocNo(saleRec.getDocNo());
                invoiceAwaitDTO.setOptDocCls(UdcEnum.DOC_CLS_SACCK.getValueCode());
                invoiceAwaitDTO.setOptDocType(UdcEnum.DOC_TYPE_SACCK.getValueCode());
                invoiceAwaitDTO.setOptDocStatus(UdcEnum.DOC_STATUS_SACCK_CONFIRM.getValueCode());
                invoiceAwaitDTO.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode());
                invoiceAwaitDTO.setCustCode(dtlList.get(0).getCustCode());
                invoiceAwaitDTO.setCustId(dtlList.get(0).getCustId());
                invoiceAwaitDTO.setCustName(dtlList.get(0).getCustName());
                invoiceAwaitDTO.setRecApplyTime(saleRec.getCreateTime());
                invoiceAwaitDTO.setDocType3("store_demand_order");
                invoiceAwaitDTOS.add(invoiceAwaitDTO);
            }
        });
        return invoiceAwaitDTOS;
    }

    private List<InvoiceAwaitDDTO> buildSalRecDtl2InvoiceAwaitDtl(List<SaleReconciliatDtlDTO> saleRecList) {
        ArrayList<InvoiceAwaitDDTO> ddtos = new ArrayList<InvoiceAwaitDDTO>();
        saleRecList.forEach(dtl -> {
            InvoiceAwaitDDTO invoiceAwaitDDTO = InvoiceAwaitDConvert.INSTANCE.sale2awaitDo((SaleReconciliatDtlDTO)dtl);
            invoiceAwaitDDTO.setId(null);
            invoiceAwaitDDTO.setMasId(null);
            if (dtl.getLineNo() != null) {
                invoiceAwaitDDTO.setLineNo(new BigDecimal(dtl.getLineNo()));
            }
            invoiceAwaitDDTO.setTaxType(dtl.getTaxCategoryCode());
            invoiceAwaitDDTO.setQty(dtl.getSoaQty());
            invoiceAwaitDDTO.setDiscountAmt(dtl.getInvDiscountAmt());
            invoiceAwaitDDTO.setNetAmt(dtl.getSoaNetAmt());
            invoiceAwaitDDTO.setTax(dtl.getSoaTaxAmt());
            invoiceAwaitDDTO.setAmt(dtl.getSoaAmt());
            invoiceAwaitDDTO.setOriginAmt(dtl.getDiscountPrice());
            invoiceAwaitDDTO.setOptDocDtlId(dtl.getId());
            if (ObjectUtil.isNotNull((Object)dtl.getMainPrice()) && !ObjUtil.equals((Object)dtl.getMainPrice(), (Object)BigDecimal.ZERO)) {
                invoiceAwaitDDTO.setItemDiscount(NumberUtil.div((Number)dtl.getDiscountPrice(), (Number)dtl.getMainPrice()));
            }
            invoiceAwaitDDTO.setInvoiceNo(dtl.getInvoiceNo());
            ddtos.add(invoiceAwaitDDTO);
        });
        return ddtos;
    }

    private SalReconciliatQueryDTO buildSaleRecParam(String param) {
        SalReconciliatQueryDTO dto = new SalReconciliatQueryDTO();
        dto.setState("PASS");
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInvedState(SaleInvStatusParam param) {
        List<InvoiceAwaitDTO> awaitDTOList = this.invoiceAwaitRepoProc.findByApplyNoIn(param.getApplyNoList());
        List optDcoIdList = awaitDTOList.stream().map(InvoiceAwaitDTO::getOptDocId).distinct().collect(Collectors.toList());
        this.invoiceAwaitRepoProc.updateInvState(param);
        SaleReconciliatDTO dto = new SaleReconciliatDTO();
        dto.setIds(optDcoIdList);
        dto.setState(param.getInvState());
        log.info("\u66f4\u65b0\u5bf9\u8d26\u5355\u5f00\u7968\u72b6\u6001,\u4f20\u53c2: {}", (Object)dto);
        this.rmiOrderRpcService.updateInvedState(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRedState(SaleInvStatusParam param) {
        if (StrUtil.equals((CharSequence)param.getInvState(), (CharSequence)UdcEnum.RED_STATE_SUCCESS.getValueCode())) {
            param.setInvState(UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode());
        }
        this.updateInvedState(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByOptDocNoBatch(List<String> optDocNos) {
        List<Long> invoiceAwaitIds;
        log.info("\u6839\u636e\u6765\u6e90\u5355\u53f7\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocNos));
        if (CollectionUtil.isNotEmpty(optDocNos) && CollectionUtil.isNotEmpty(invoiceAwaitIds = this.invoiceAwaitRepoProc.selectInvoiceAwaitIdByOptDoc(optDocNos, Collections.EMPTY_LIST))) {
            this.invoiceAwaitRepoProc.updateDeleteFlagByIdBatch(1, invoiceAwaitIds);
            this.invoiceAwaitDRepoProc.updateDeleteFlagByMasIdBatch(1, invoiceAwaitIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByOptDocIdBatch(List<Long> optDocIds) {
        List<Long> invoiceAwaitIds;
        log.info("\u6839\u636e\u6765\u6e90\u5355\u636e\u4e3b\u952eid\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocIds));
        if (CollectionUtil.isNotEmpty(optDocIds) && CollectionUtil.isNotEmpty(invoiceAwaitIds = this.invoiceAwaitRepoProc.selectInvoiceAwaitIdByOptDoc(Collections.EMPTY_LIST, optDocIds))) {
            this.invoiceAwaitRepoProc.updateDeleteFlagByIdBatch(1, invoiceAwaitIds);
            this.invoiceAwaitDRepoProc.updateDeleteFlagByMasIdBatch(1, invoiceAwaitIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invoiceAwaitOrderBySalDo(String param) {
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocClss(Arrays.asList(UdcEnum.DOC_CLS_DO.getValueCode(), UdcEnum.DOC_CLS_RSO.getValueCode()));
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = this.invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if (CollectionUtil.isEmpty(ruleConfigDTOList)) {
            log.info("\u672a\u914d\u7f6e\u5f00\u7968\u8bbe\u7f6e\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968");
            XxlJobLogger.log((String)"\u672a\u914d\u7f6e\u5f00\u7968\u8bbe\u7f6e\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968", (Object[])new Object[0]);
            return;
        }
        List<String> optDocTypes = ruleConfigDTOList.stream().map(InvoiceRuleConfigDTO::getOptDocType).collect(Collectors.toList());
        List<InvoiceAwaitDO> invoiceAwaitDOList = this.invoiceAwaitRepo.getAllByOptDocTypeIn(optDocTypes);
        List<Object> salDoDocNos = new ArrayList();
        if (CollUtil.isNotEmpty(invoiceAwaitDOList)) {
            salDoDocNos = invoiceAwaitDOList.stream().map(InvoiceAwaitDO::getOptDocNo).collect(Collectors.toList());
        }
        try {
            List docTypes = optDocTypes.stream().map(e -> {
                String docType = e.replace("DO_", "");
                docType = docType.replace("RSO_", "");
                return docType;
            }).collect(Collectors.toList());
            SalDoQueryReqDTO salDoQueryReqDTO = new SalDoQueryReqDTO();
            salDoQueryReqDTO.setInDocStatus(Arrays.asList(UdcEnum.SAL_DO_DOC_STATUS.getValueCode()));
            if (optDocTypes.contains(UdcEnum.INVOICE_CONFIG_SACCK_SAL_DO.getValueCode())) {
                salDoQueryReqDTO.setNotInDocType(Arrays.asList("RJ", "RW"));
            } else {
                salDoQueryReqDTO.setInDocType(docTypes);
            }
            salDoQueryReqDTO.setNotInDocNoList(salDoDocNos);
            log.info("\u67e5\u8be2\u8981\u751f\u6210\u7684\u53d1\u8d27\u5355\u5165\u53c2\uff0c{}", (Object)JSONUtil.toJsonStr((Object)salDoQueryReqDTO));
            ApiResult listApiResult = this.salDoRpcService.querySalDoList(salDoQueryReqDTO);
            log.info("\u67e5\u8be2\u8981\u751f\u6210\u7684\u53d1\u8d27\u5355\u7ed3\u679c\uff0c{}", (Object)JSONUtil.toJsonStr((Object)listApiResult));
            if (listApiResult.isFailed() || CollUtil.isEmpty((Collection)((Collection)listApiResult.getData()))) {
                log.info("\u4e3a\u67e5\u8be2\u5230\u5df2\u7b7e\u6536\u7684\u53d1\u8d27\u5355\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968");
                XxlJobLogger.log((String)"\u4e3a\u67e5\u8be2\u5230\u5df2\u7b7e\u6536\u7684\u53d1\u8d27\u5355\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968", (Object[])new Object[0]);
                return;
            }
            List<InvoiceAwaitDTO> dtos = this.buildInvoiceAwaitParam((List)listApiResult.getData());
            log.info("\u5c01\u88c5\u751f\u6210\u4ee3\u5f00\u53d1\u7968\u7684\u53c2\u6570,{}", (Object)JSONUtil.toJsonStr(dtos));
            ArrayList list = new ArrayList();
            dtos.forEach(item -> {
                String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
                InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do((InvoiceAwaitDTO)item);
                awaitDO.setDocNo(docNo);
                this.flexFieldUtilService.handFlexFieldValueFeference("INVOICE_AWAIT", (Object)awaitDO);
                InvoiceAwaitDO invoiceAwaitDO = (InvoiceAwaitDO)this.invoiceAwaitRepo.save(awaitDO);
                List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
                dtlList.forEach(dtl -> {
                    InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do((InvoiceAwaitDDTO)dtl);
                    dtlDo.setMasId(invoiceAwaitDO.getId());
                    this.invoiceAwaitDRepo.save(dtlDo);
                    list.add(dtl.getOptDocDtlId());
                });
                InvoiceApplyParam applyParam = this.getInvoiceApplyParamByAwaitOrder(invoiceAwaitDO);
                log.info("\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\uff1a{}", (Object)JSONUtil.toJsonStr((Object)applyParam));
                this.invoiceApply(applyParam);
            });
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u53d1\u8d27\u5355\u6570\u636e\u5931\u8d25,{}", (Object)e2.getMessage());
            XxlJobLogger.log((String)e2.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    public InvoiceApplyParam getInvoiceApplyParamByAwaitOrder(InvoiceAwaitDO save) {
        InvoiceApplyParam applyParam = new InvoiceApplyParam();
        applyParam.setCustInvTitle(save.getInvTitle());
        applyParam.setCustTaxNo(save.getTaxerNo());
        applyParam.setInvType(save.getInvType());
        applyParam.setInvCustCode(save.getCustCode());
        applyParam.setInvCustId(save.getCustId());
        applyParam.setInvCustName(save.getCustName());
        applyParam.setCustBank(save.getInvBankName());
        applyParam.setCustBankAcc(save.getInvBankAcc());
        applyParam.setCustTel(save.getInvTel());
        applyParam.setCustAdd(save.getInvAddress());
        applyParam.setInvTitleType(save.getInvTitleType());
        applyParam.setInvPicName(save.getInvPicName());
        applyParam.setInvPicPhone(save.getInvPicPhone());
        applyParam.setInvEmail(save.getInvEmail());
        applyParam.setIds(List.of(save.getId()));
        return applyParam;
    }

    private List<InvoiceAwaitDTO> buildInvoiceAwaitParam(List<SalDoQueryRespDTO> list) {
        ArrayList<InvoiceAwaitDTO> result = new ArrayList<InvoiceAwaitDTO>();
        List custCodes = list.stream().map(SalDoQueryRespDTO::getPreCustCode).distinct().collect(Collectors.toList());
        CrmCustRpcDtoParam custRpcDtoParam = new CrmCustRpcDtoParam();
        custRpcDtoParam.setCustCodes(custCodes);
        log.info("\u6279\u91cf\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2,{}", custCodes);
        ApiResult custByParam = this.crmCustRpcService.getCustByParam(custRpcDtoParam);
        log.info("\u6279\u91cf\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c,{}", (Object)JSONUtil.toJsonStr((Object)custByParam));
        if (custByParam.isFailed() || CollUtil.isEmpty((Collection)((Collection)custByParam.getData()))) {
            throw new BusinessException("\u6279\u91cf\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        Map<String, CrmCustRespDTO> custInfoMap = ((List)custByParam.getData()).stream().collect(Collectors.toMap(k -> k.getCustCode(), v -> v));
        List ouIds = list.stream().map(SalDoQueryRespDTO::getOuId).distinct().collect(Collectors.toList());
        OrgOuRpcDtoParam ouRpcDtoParam = new OrgOuRpcDtoParam();
        ouRpcDtoParam.setOuIds(ouIds);
        log.info("\u6279\u91cf\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5165\u53c2,{}", custCodes);
        List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(ouRpcDtoParam);
        log.info("\u6279\u91cf\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u7ed3\u679c,{}", (Object)JSONUtil.toJsonStr((Object)ouDtoByParam));
        if (CollUtil.isEmpty((Collection)ouDtoByParam)) {
            throw new BusinessException("\u6279\u91cf\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5f02\u5e38");
        }
        Map<Long, OrgOuRpcDTO> ouRpcDTOMap = ouDtoByParam.stream().collect(Collectors.toMap(k -> k.getId(), v -> v));
        for (SalDoQueryRespDTO salDoQueryRespDTO : list) {
            InvoiceAwaitDTO invoiceAwaitDTO = InvoiceAwaitConvert.INSTANCE.salDo2AwaitDto(salDoQueryRespDTO);
            if (!CollUtil.isNotEmpty((Collection)salDoQueryRespDTO.getSalDoDQueryRespDTOList())) continue;
            List<InvoiceAwaitDDTO> dtlList = this.buildInvoiceAwaitDParam(salDoQueryRespDTO);
            invoiceAwaitDTO.setInvoiceAwaitDDTOList(dtlList);
            BigDecimal totalInvAmt = dtlList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getInvAmt())).map(item -> item.getInvAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceAwaitDTO.setAmt(totalInvAmt);
            invoiceAwaitDTO.setId(null);
            invoiceAwaitDTO.setOptDocId(salDoQueryRespDTO.getId());
            invoiceAwaitDTO.setOptDocNo(salDoQueryRespDTO.getDocNo());
            invoiceAwaitDTO.setOptDocCls(salDoQueryRespDTO.getDocNo().startsWith("RDO") ? UdcEnum.DOC_CLS_RDO.getValueCode() : UdcEnum.DOC_CLS_DO.getValueCode());
            invoiceAwaitDTO.setOptDocType(salDoQueryRespDTO.getRelateDocType().equals("RW") ? UdcEnum.INVOICE_CONFIG_SACCK_SAL_RDO_RW.getValueCode() : (salDoQueryRespDTO.getRelateDocType().equals("RJ") ? UdcEnum.INVOICE_CONFIG_SACCK_SAL_RDO_RJ.getValueCode() : UdcEnum.INVOICE_CONFIG_SACCK_SAL_DO.getValueCode()));
            invoiceAwaitDTO.setOptDocStatus(UdcEnum.SAL_DO_DOC_STATUS.getValueCode());
            invoiceAwaitDTO.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode());
            invoiceAwaitDTO.setMainCustCode(salDoQueryRespDTO.getPreCustCode());
            invoiceAwaitDTO.setMainCustId(custInfoMap.containsKey(salDoQueryRespDTO.getPreCustCode()) ? custInfoMap.get(salDoQueryRespDTO.getPreCustCode()).getId() : 0L);
            invoiceAwaitDTO.setMainCustName(salDoQueryRespDTO.getPreCustName());
            invoiceAwaitDTO.setCurrRate(BigDecimal.ONE);
            invoiceAwaitDTO.setCurrCode("CNY");
            invoiceAwaitDTO.setOuCode(ouRpcDTOMap.containsKey(salDoQueryRespDTO.getOuId()) ? ouRpcDTOMap.get(salDoQueryRespDTO.getOuId()).getOuCode() : "");
            invoiceAwaitDTO.setOuName(ouRpcDTOMap.containsKey(salDoQueryRespDTO.getOuId()) ? ouRpcDTOMap.get(salDoQueryRespDTO.getOuId()).getOuName() : "");
            result.add(invoiceAwaitDTO);
        }
        return result;
    }

    private List<InvoiceAwaitDDTO> buildInvoiceAwaitDParam(SalDoQueryRespDTO salDoQueryRespDTO) {
        List list = salDoQueryRespDTO.getSalDoDQueryRespDTOList();
        ArrayList<InvoiceAwaitDDTO> ddtos = new ArrayList<InvoiceAwaitDDTO>();
        list.stream().forEach(dtl -> {
            InvoiceAwaitDDTO invoiceAwaitDDTO = InvoiceAwaitDConvert.INSTANCE.salDod2awaitDo((SalDoDQueryRespDTO)dtl);
            invoiceAwaitDDTO.setId(null);
            invoiceAwaitDDTO.setMasId(null);
            invoiceAwaitDDTO.setCustId(salDoQueryRespDTO.getCustId());
            invoiceAwaitDDTO.setCustCode(salDoQueryRespDTO.getCustCode());
            invoiceAwaitDDTO.setCustName(salDoQueryRespDTO.getCustName());
            invoiceAwaitDDTO.setShipTime(salDoQueryRespDTO.getDocTime());
            invoiceAwaitDDTO.setConfirmTime(salDoQueryRespDTO.getConfirmTime());
            invoiceAwaitDDTO.setSoDate(salDoQueryRespDTO.getSoTime());
            invoiceAwaitDDTO.setDiscountAmt(dtl.getFlDeductionAmt());
            invoiceAwaitDDTO.setTax(dtl.getTaxAmt());
            invoiceAwaitDDTO.setGiftsFlag(BigDecimal.ZERO.compareTo(dtl.getPrice()) == 0 ? "\u662f" : "\u5426");
            invoiceAwaitDDTO.setOriginAmt(dtl.getPrice());
            invoiceAwaitDDTO.setMainPrice(dtl.getBasePrice());
            invoiceAwaitDDTO.setOptDocDtlId(dtl.getId());
            invoiceAwaitDDTO.setInvDiscountAmt(dtl.getFlDeductionAmt());
            invoiceAwaitDDTO.setInvAmt(dtl.getAmt().subtract(dtl.getFlDeductionAmt()));
            invoiceAwaitDDTO.setInvNetAmt(invoiceAwaitDDTO.getInvAmt().divide(BigDecimal.ONE.add(dtl.getTaxRate()), 4, RoundingMode.HALF_UP));
            invoiceAwaitDDTO.setInvTaxAmt(invoiceAwaitDDTO.getInvAmt().subtract(invoiceAwaitDDTO.getInvNetAmt()));
            ddtos.add(invoiceAwaitDDTO);
        });
        return ddtos;
    }

    public InvoiceAwaitServiceImpl(InvoiceAwaitRepoProc invoiceAwaitRepoProc, InvoiceAwaitDRepo invoiceAwaitDRepo, InvoiceAwaitDRepoProc invoiceAwaitDRepoProc, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService orgRpcService, WorkflowRpcService workflowRpcService, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, TransactionTemplate transactionTemplate, InvoiceRuleConfigDomainService ruleConfigDomainService, SystemRpcService systemRpcService, InvoiceApplyRepoProc invoiceApplyRepoProc, RmiOrderRpcService rmiOrderRpcService, InvoiceAwaitRepo invoiceAwaitRepo, SysNumberGenerator sysNumberGenerator, SaleInvDomainService saleInvDomainService, MessageQueueTemplate messageQueueTemplate, UdcProvider udcProvider, InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc, SalDoRpcService salDoRpcService, CrmCustRpcService crmCustRpcService, OrgOuRpcService orgOuRpcService, FlexFieldUtilService flexFieldUtilService, AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService) {
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.invoiceAwaitDRepoProc = invoiceAwaitDRepoProc;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.orgRpcService = orgRpcService;
        this.workflowRpcService = workflowRpcService;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.transactionTemplate = transactionTemplate;
        this.ruleConfigDomainService = ruleConfigDomainService;
        this.systemRpcService = systemRpcService;
        this.invoiceApplyRepoProc = invoiceApplyRepoProc;
        this.rmiOrderRpcService = rmiOrderRpcService;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.sysNumberGenerator = sysNumberGenerator;
        this.saleInvDomainService = saleInvDomainService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.udcProvider = udcProvider;
        this.invoiceRuleConfigRepoProc = invoiceRuleConfigRepoProc;
        this.salDoRpcService = salDoRpcService;
        this.crmCustRpcService = crmCustRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.flexFieldUtilService = flexFieldUtilService;
        this.abstractInvoiceSaveService = abstractInvoiceSaveService;
    }
}

