package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyPayServiceImpl implements FinApPayVerApplyPayService {

    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PayOrderRepoProc payOrderRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplyPaySaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }

        List<String> payDocNoList = saveList.stream().map(FinApPayVerApplyPaySaveDTO::getPayDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<PayOrderDTO> payOrderDTOList = payOrderRepoProc.selectInOutCustByPayOrderNo(payDocNoList);
        Map<String, PayOrderDTO> payOrderMap = CollectionUtil.isEmpty(payOrderDTOList) ? new HashMap<>() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1));


        finApPayVerApplyPayRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplyPayDO entity = FinApPayVerApplyPayConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    PayOrderDTO payOrderDTO = payOrderMap.get(entity.getPayDocNo());
                    if (Objects.nonNull(payOrderDTO)){
                        String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? payOrderDTO.getInOutCust() : entity.getInOutCust();
                        String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                        entity.setInOutCust(inOutCust);
                        entity.setRelevanceOuCode(relevanceOuCode);
                    }
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyPayRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyPayVO> finApPayVerApplyPayVOList = finApPayVerApplyPayRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplyPayVOList)){
            return Collections.EMPTY_LIST;
        }

        List<String> relevanceOuCodeList = finApPayVerApplyPayVOList.stream().map(FinApPayVerApplyPayVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyPayVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finApPayVerApplyPayVOList;
    }

	/**
	 * 根据条件查询核销收款单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyPayVO> listByQuery(FinApPayVerApplyPayQuery query) {
		return finApPayVerApplyPayRepoProc.listByQuery(query)
				.stream()
				.map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方收款单号或者明细ID查询
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyPayVO> listByOutRecDocNoOrDId(FinApPayVerApplyQuery query) {
	/*	if(StrUtil.isEmpty(query.getOutPayDocNo()) && StrUtil.isEmpty(query.getOutPayDId())){
			return null;
		}*/
		return finApPayVerApplyPayRepoProc.listByOutRecDocNoOrDId(query);
	}
}
