package com.elitesland.fin.domain.entity.recorder;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lucan.liu
 * @date 2023-09-08
 */
@Data
@Entity
@Table(name = "rec_order_ext_dtl")
@DynamicInsert
@DynamicUpdate
@Comment("收款单明细表扩展表")
public class RecOrderExDtlDo extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4541906443449866652L;

    @ApiModelProperty("收款单明细表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '收款单明细表关联id'")
    private Long relateId;

    @ApiModelProperty("收款主扩展表关联id")
    @Column(name = "mas_id", columnDefinition = "bigint(20)  comment '收款主扩展表关联id'")
    private Long masId;

    @ApiModelProperty("第三方收款单明细id")
    @Column(name = "third_order_dt_id", columnDefinition = "varchar(32)  comment '第三方收款单明细id'")
    private String thirdOrderDtId;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "varchar(32)  comment '客户编码'")
    private String custCode;

    @ApiModelProperty("收款性质")
    @Column(name = "nature_payment", columnDefinition = "varchar(32)  comment '收款性质'")
    private String naturePayment;

    @ApiModelProperty("销售组织编码")
    @Column(name = "bu_code", columnDefinition = "varchar(32)  comment '销售组织编码'")
    private String buCode;

    @ApiModelProperty("业务员编码")
    @Column(name = "business_code", columnDefinition = "varchar(32)  comment '业务员编码'")
    private String businessCode;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(32)  comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "exchange_rate", columnDefinition = "varchar(32)  comment '汇率'")
    private String exchangeRate;

    @ApiModelProperty("收款银行账户")
    @Column(name = "rec_bank", columnDefinition = "varchar(32)  comment '收款银行账户'")
    private String recBank;

    @ApiModelProperty("付款银行账户")
    @Column(name = "pay_bank", columnDefinition = "varchar(32)  comment '付款银行账户'")
    private String payBank;

    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @ApiModelProperty("已核销金额")
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;

    /**
     * 总金额.
     */
    @Transient
    private BigDecimal totalAmt;
    @Transient
    private Long extId;
    @Transient
    private Integer version;
    @Transient
    private Long recDId;
}