package com.elitesland.fin.application.service.artype;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.artype.ArTypeDtlConvert;
import com.elitesland.fin.application.facade.vo.artype.ArTypeDtlVO;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.domain.service.artype.ArTypeDtlDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class ArTypeDtlServiceImpl implements ArTypeDtlService{

    private final ArTypeDtlDomainService arTypeDtlDomainService;

    @Override
    @SysCodeProc
    public PagingVO<ArTypeDtlVO> page(ArTypeDtlPageParam pageParam){
        PagingVO<ArTypeDtlDTO> pagingVO = arTypeDtlDomainService.page(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<ArTypeDtlVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        List<ArTypeDtlVO> arTypeDtlVOList = pagingVO.getRecords().stream().map(ArTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());


        return PagingVO.<ArTypeDtlVO>builder()
                .total(pagingVO.getTotal())
                .records(arTypeDtlVOList)
                .build();
    }

}
