package com.elitesland.fin.utils;

import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/**
 * @author sunxw
 * @Description:
 * @date 2022/5/30 - 21:59
 */
public class TimeUtil {

    private static String datePattern = "yyyy-MM-dd";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);

    //string 转 cron格式
    public static String formatDateByPattern(Date date, String dateFormat){
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
    public static String getCron(Date  date){
        String dateFormat="ss mm HH dd MM ?";
        //String dateFormat="ss mm HH dd MM ? yyyy";
        return formatDateByPattern(date, dateFormat);
    }

    /**
     * 日期转string(带-)
     * @param date
     * @return
     */
    public static String dateToYmd(LocalDate date) {
        return date == null ? "" : date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate dateFromYmd(String ymd) {
        return StringUtils.isEmpty(ymd) ? null : LocalDate.parse(ymd, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    /**
     * 日期转string(不带-)
     * @param date
     * @return
     */
    public static String date2String(LocalDate date) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate now = LocalDate.now();
        return format.format(now);
    }

    /**
     * 年月日转localDate
     * @param yyyyMMdd
     * @return
     */
    public static LocalDate string2Date(String yyyyMMdd){
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(yyyyMMdd,format);
    }

    public static String time2String(LocalTime time) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("HHmmss");
        LocalTime now = LocalTime.now();
        return format.format(now);
    }

    public static String datetime2String(LocalDateTime localDateTime){
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime now = LocalDateTime.now();
        return format.format(now);
    }

    public static LocalDateTime getFirstOfYear(LocalDateTime dateTime) {
        int currentYear = dateTime.getYear();
        Date date = getFirstOfYear(currentYear);
        LocalDate format = format(date);
        LocalDateTime firstOfYear = LocalDateTime.of(format, LocalTime.MIN);
        return firstOfYear;
    }

    public static LocalDateTime getLastOfYear(LocalDateTime dateTime) {
        int currentYear = dateTime.getYear();
        Date date = getLastOfYear(currentYear);
        LocalDate format = format(date);
        LocalDateTime lastOfYear = LocalDateTime.of(format, LocalTime.MAX);
        return lastOfYear;
    }

    public static Date getFirstOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.YEAR, year);
        return calendar.getTime();
    }

    public static LocalDate format(Date date) {
        String format = simpleDateFormat.format(date);
        LocalDate localDate = LocalDate.parse(format);
        return localDate;
    }

    public static Date getLastOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.YEAR, year);
        calendar.roll(Calendar.DAY_OF_YEAR, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

}
