/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.creditaccount;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountIocConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.domain.service.creditaccount.CreditAccountIocDomainService;
import com.elitesland.fin.entity.creditaccount.CreditAccountIoc;
import com.elitesland.fin.entity.creditaccount.CreditAccountIocDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountIocRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountIocRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CreditAccountIocDomainServiceImpl
implements CreditAccountIocDomainService {
    private final CreditAccountIocRepo creditAccountIocRepo;
    private final CreditAccountIocRepoProc CreditAccountIocRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountIocDTO> search(CreditAccountIocParamVO param) {
        PagingVO<CreditAccountIocDTO> pagingVo = this.CreditAccountIocRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAccountIoc(CreditAccountIoc accountIoc, Optional<CreditAccountIocDTO> optional) {
        if (optional.isPresent()) {
            CreditAccountIocDTO accountIocDTO = optional.get();
            accountIoc.setIoCode(accountIocDTO.getIoCode());
            accountIoc.setId(accountIocDTO.getId());
            accountIoc.setCreator(accountIocDTO.getCreator());
            accountIoc.setCreateUserId(accountIocDTO.getCreateUserId());
            accountIoc.setCreateTime(accountIocDTO.getCreateTime());
            accountIoc.setModifyTime(LocalDateTime.now());
        } else {
            accountIoc.setId(null);
            accountIoc.setCreator(null);
            accountIoc.setCreateUserId(null);
            accountIoc.setCreateTime(LocalDateTime.now());
            accountIoc.setModifyUserId(null);
            accountIoc.setUpdater(null);
            accountIoc.setModifyTime(LocalDateTime.now());
        }
        CreditAccountIocDO accountIocDO = CreditAccountIocConvert.INSTANCE.enToDo(accountIoc);
        Long id = ((CreditAccountIocDO)this.creditAccountIocRepo.save(accountIocDO)).getId();
        return id;
    }

    @Override
    @SysCodeProc
    public Optional<CreditAccountIocDTO> findById(Long id) {
        return this.creditAccountIocRepo.findById(id).map(CreditAccountIocConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<CreditAccountIocDTO> findByCode(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return Optional.empty();
        }
        CreditAccountIocParamVO param = new CreditAccountIocParamVO();
        param.setIoCode(code);
        JPAQuery<CreditAccountIocDTO> jpaQuery = this.CreditAccountIocRepoProc.select(param);
        return Optional.of((CreditAccountIocDTO)jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<CreditAccountIocDTO> whAreaSettingDTOList = this.creditAccountIocRepo.findAllById(idList).stream().map(CreditAccountIocConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> findByCodeBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.EMPTY_LIST;
        }
        CreditAccountIocParamVO param = new CreditAccountIocParamVO();
        param.setIoCodeList(codeList);
        JPAQuery<CreditAccountIocDTO> jpaQuery = this.CreditAccountIocRepoProc.select(param);
        List accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocDTO> selectByParam(CreditAccountIocParamVO param) {
        JPAQuery<CreditAccountIocDTO> jpaQuery = this.CreditAccountIocRepoProc.select(param);
        List accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        this.CreditAccountIocRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    @Override
    public List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam) {
        return this.CreditAccountIocRepoProc.queryByAccountIocParam(accountIocParam);
    }

    public CreditAccountIocDomainServiceImpl(CreditAccountIocRepo creditAccountIocRepo, CreditAccountIocRepoProc CreditAccountIocRepoProc2) {
        this.creditAccountIocRepo = creditAccountIocRepo;
        this.CreditAccountIocRepoProc = CreditAccountIocRepoProc2;
    }
}

