package com.elitesland.fin.application.facade.param.flow;

import com.elitesland.fin.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


@Data
@ApiModel(description = "账户流水")
public class OuIoFlowParam extends PartitionQueryParam {

    private static final long serialVersionUID = -1482334848440238038L;

    @ApiModelProperty("出账公司编码")
    private String oOuCode;

    @ApiModelProperty("入账公司编码")
    private String iOuCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据集合")
    private List<String> sourceDocList;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源id")
    private String sourceId;

    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("流水号集合")
    private List<String> flowNoList;

    @ApiModelProperty("发生金额从")
    private BigDecimal amountFrom;

    @ApiModelProperty("发生金额至")
    private BigDecimal amountTo;

    @ApiModelProperty("交易日期起始")
    private LocalDateTime transactionTimeS;

    @ApiModelProperty("交易日期截至")
    private LocalDateTime transactionTimeE;

    @ApiModelProperty("来源单号集合")
    private List<String> sourceNoList;

    @ApiModelProperty("业务类型")
    private List<String> businessTypes;
}
