package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.ApOrderExportEntity;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_AP_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultApOrderExportServiceImpl implements DataExport<ApOrderExportEntity, ApOrderPageParam> {
    private final ApOrderRepoProc apOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public String getTmplCode() {
        return FIN_AP_EXPORT_DEFAULT;
    }

    @Override
    @SysCodeProc
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_AP_ORDER_LIST, businessObjectType = FinBusinessObjectConstant.FIN_AP_ORDER,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "应付单默认导出",operationCode = FinBusinessObjectConstant.FIN_AP_ORDER_EXPORT_DEFAULT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<ApOrderExportEntity> executeExport(ApOrderPageParam queryParam) {
        PagingVO<ApOrderExportEntity> page = apOrderRepoProc.defaultExport(queryParam);
        List<ApOrderExportEntity> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return new PagingVO<>();
        }
        List<String> relOuCodes = records.stream().map(ApOrderExportEntity::getRelevanceOuCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO<>(page.getTotal(), ExcelConvertUtils.convertLoosely(records, ApOrderExportEntity.class));
    }

    @Override
    public Integer pageSize() {
        return 1000;
    }
}
