package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
public interface AgingRangeOuDomainService {

    PagingVO<AgingRangeOuDTO> ouPage(AgingRangeOuPageParam pageParam);

    Long addOu(AgingRangeOuSaveParam saveParam);

    void cancelOu(List<Long> ids);

    /**
     * 账龄区间分配公司保存
     *
     * @param saveParamList 入参
     * @return 账龄区间分配公司ID
     */
    List<Long> save(List<AgingRangeOuSaveParam> saveParamList);

    /**
     * 根据主表ID删除账龄区间分配公司
     *
     * @param masId 主表ID
     * @return
     */
    void deleteByMasId(Long masId);

    /**
     * 根据主表ID查询账龄区间分配公司
     *
     * @param masId 主表ID
     * @return 账龄区间分配公司
     */
    List<AgingRangeOuVO> selectByMasId(Long masId);

    /**
     * 根据入参查询账龄区间分配公司
     *
     * @param queryVO 入参
     * @return 账龄区间分配公司
     */
    List<AgingRangeOuVO> selectByParam(AgingRangeOuPageParam queryVO);

    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    void updateDeleteFlagBatchByMasId(Integer deleteFlag, List<Long> masIds);

}
