package com.elitesland.fin.entity.payment;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "payment_rule_config")
@org.hibernate.annotations.Table(appliesTo = "payment_rule_config", comment = "支付配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "payment_rule_config", description = "支付配置")
public class PaymentRuleConfigDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4186477882371888523L;

    @ApiModelProperty("编码")
    @Column(name = "rule_code", columnDefinition = "varchar(32)  comment '编码'")
    private String ruleCode;

    @ApiModelProperty("名称")
    @Column(name = "rule_name", columnDefinition = "varchar(32)  comment '名称'")
    private String ruleName;

    @ApiModelProperty("扣款单据")
    @Column(name = "opt_doc", columnDefinition = "varchar(32)  comment '扣款单据'")
    private String optDoc;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @Column(name = "status", columnDefinition = "varchar(32) default 'ACTIVE'  comment '是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS'")
    private String status;

}