/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.adjustorder.AdjustOrderConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.excel.adjust.AdjustOrderImportEntity;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderSaveParam;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderServiceImpl;
import com.elitesland.fin.application.service.excel.imp.AdjustOrderSubmitJob;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdjustOrderImportServiceImpl
implements DataImport<AdjustOrderImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(AdjustOrderImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final AccountRepoProc accountRepoProc;
    private final AdjustOrderRepo adjustOrderRepo;
    private final UdcProvider udcProvider;
    private final SysNumberGenerator sysNumberGenerator;
    private final AdjustOrderServiceImpl adjustOrderService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final AdjustOrderSubmitJob adjustOrderSubmitJob;

    public String getTmplCode() {
        return "yst_fin_adjust_order_import";
    }

    public Integer stepSize() {
        return 50000;
    }

    public List<String> executeImport(List<AdjustOrderImportEntity> dataList, int rowId) {
        if (CollectionUtil.isEmpty(dataList)) {
            return List.of();
        }
        Set<String> accountCodeList = dataList.stream().map(AdjustOrderImportEntity::getAccCode).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        Map<Object, Object> accountMap = new HashMap();
        if (CollectionUtil.isNotEmpty(accountCodeList)) {
            AccountParam accountParam = new AccountParam();
            accountParam.setAccountCodes(accountCodeList);
            accountParam.setState("ACTIVE");
            List<AccountDTO> accountDTOList = this.accountRepoProc.getAccountByAccountParam(accountParam);
            accountMap = accountDTOList.stream().collect(Collectors.toMap(AccountDTO::getAccountCode, t -> t, (t1, t2) -> t1));
        }
        Map udcCodeMap = this.udcProvider.getValueMapByUdcCode(UdcEnum.ADJUST_TYPE_1.getModel(), Set.of(UdcEnum.ADJUST_TYPE_1.getCode(), UdcEnum.FIN_ADJUST_REASON_1.getCode()));
        Map<String, String> adjustTypeMap = ((Map)udcCodeMap.get(UdcEnum.ADJUST_TYPE_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        Map<String, String> adjustReasonMap = ((Map)udcCodeMap.get(UdcEnum.FIN_ADJUST_REASON_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<AdjustOrderSaveParam> saveList = new ArrayList<AdjustOrderSaveParam>();
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        for (AdjustOrderImportEntity entity : dataList) {
            if (!StrUtil.isNotBlank((CharSequence)entity.getAccCode()) || !NumberUtil.isNumber((CharSequence)entity.getTotalAmt()) || !StrUtil.equals((CharSequence)entity.getAdjTypeName(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCodeName())) continue;
            BigDecimal totalAmt = amtMap.getOrDefault(entity.getAccCode(), BigDecimal.ZERO);
            totalAmt = NumberUtil.add((Number)totalAmt, (Number)new BigDecimal(entity.getTotalAmt()));
            amtMap.put(entity.getAccCode(), totalAmt);
        }
        HashMap<String, OrgStoreBaseRpcDTO> storeMap = new HashMap();
        HashMap<String, String> storeBankAccMap = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(accountMap)) {
            OrgStoreBaseRpcParam storeBaseRpcParam = new OrgStoreBaseRpcParam();
            storeBaseRpcParam.setStoreCodeList(accountMap.values().stream().map(AccountDTO::getAccountHolderCode).filter(Objects::nonNull).distinct().toList());
            ApiResult storeResult = this.orgStoreRpcService.findSimpleStoreByParam(storeBaseRpcParam);
            if (storeResult.isFailed() || CollectionUtil.isEmpty((Collection)((Collection)storeResult.getData()))) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u53f7\u6240\u5c5e\u95e8\u5e97\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            }
            storeMap = ((List)storeResult.getData()).stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, c -> c));
            Set storedOuCodes = ((List)storeResult.getData()).stream().map(OrgStoreBaseRpcDTO::getStoredOuCode).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
            log.info("\u50a8\u503c\u516c\u53f8\u7f16\u7801: {}", (Object)JSONUtil.toJsonString(storedOuCodes));
            List storedOuList = storedOuCodes.isEmpty() ? Collections.emptyList() : this.orgOuRpcService.findSimpleByOuCodes(new ArrayList(storedOuCodes));
            Set storedOuIds = CollUtil.isEmpty(storedOuList) ? Collections.emptySet() : storedOuList.stream().map(OrgOuRpcSimpleDTO::getId).filter(Objects::nonNull).collect(Collectors.toSet());
            log.info("\u50a8\u503c\u516c\u53f8ID: {}", (Object)JSONUtil.toJsonString(storedOuIds));
            List ouBankList = storedOuIds.isEmpty() ? Collections.emptyList() : this.orgOuRpcService.findOuBankDetail(UdcEnum.COM_OU_TYPE_10.getValueCode(), new ArrayList(storedOuIds));
            log.info("\u50a8\u503c\u516c\u53f8\u94f6\u884c\u4fe1\u606f: {}", (Object)JSONUtil.toJsonString(ouBankList));
            for (OrgOuBankRpcDTO orgOuBankRpcDTO : ouBankList) {
                if (!"IN".equals(orgOuBankRpcDTO.getAccType())) continue;
                storeBankAccMap.put(orgOuBankRpcDTO.getOuCode(), orgOuBankRpcDTO.getBankAcc());
            }
        }
        for (AdjustOrderImportEntity importEntity : dataList) {
            AdjustOrderSaveParam adjustOrderSaveParam = new AdjustOrderSaveParam();
            ArrayList<String> errorList = new ArrayList<String>();
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
            this.checkImportMandatoryField(importEntity, errorList, rowId);
            this.checkUdc(rowId, importEntity, adjustOrderSaveParam, errorList, adjustTypeMap, adjustReasonMap);
            this.checkAccount(rowId, importEntity, adjustOrderSaveParam, errorList, accountMap, amtMap, storeMap, storeBankAccMap);
            adjustOrderSaveParam.setRemark(importEntity.getRemark());
            adjustOrderSaveParam.setType(UdcEnum.ADJUST_ORDER_TYPE_YETZ.getValueCode());
            adjustOrderSaveParam.setDocNo(docNo);
            adjustOrderSaveParam.setState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            adjustOrderSaveParam.setExtensionInfo(importEntity.getExtensionInfo());
            adjustOrderSaveParam.setDataSource("IMPORT");
            adjustOrderSaveParam.setProcessStatus("TODO");
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                errorResult.add(null);
                saveList.add(adjustOrderSaveParam);
            }
            ++rowId;
        }
        long count = errorResult.stream().filter(Objects::nonNull).count();
        if (count > 0L) {
            ArrayList<String> newErrorResult = new ArrayList<String>();
            for (String s : errorResult) {
                if (s == null) {
                    s = "\u89e3\u6790\u6210\u529f";
                }
                newErrorResult.add(s);
            }
            log.info("\u5b58\u8c03\u6574\u5355\u5bfc\u5165\u6570\u636e\u9519\u8bef\u6570\u636e: {}", (Object)JSONUtil.toJsonString(newErrorResult));
            return newErrorResult;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            log.info("\u4fdd\u5b58\u8c03\u6574\u5355\u5bfc\u5165\u6570\u636e: {}", (Object)JSONUtil.toJsonString(saveList));
            this.saveData(saveList);
        }
        return null;
    }

    public void afterImport(boolean sync) {
        log.info("\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1,\u5904\u7406\u540e\u7eed\u903b\u8f91");
        this.adjustOrderSubmitJob.submitDraftAdjustOrders(null);
    }

    private void checkUdc(int rowId, AdjustOrderImportEntity importEntity, AdjustOrderSaveParam adjustOrderSaveParam, List<String> errorList, Map<String, String> adjustTypeMap, Map<String, String> adjustReasonMap) {
        if (adjustReasonMap.containsKey(importEntity.getAdjReasonName())) {
            adjustOrderSaveParam.setAdjReason(adjustReasonMap.get(importEntity.getAdjReasonName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
        if (adjustTypeMap.containsKey(importEntity.getAdjTypeName())) {
            adjustOrderSaveParam.setAdjType(adjustTypeMap.get(importEntity.getAdjTypeName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
    }

    private void checkAccount(int rowId, AdjustOrderImportEntity importEntity, AdjustOrderSaveParam adjustOrderSaveParam, List<String> errorList, Map<String, AccountDTO> accountMap, Map<String, BigDecimal> amtMap, Map<String, OrgStoreBaseRpcDTO> storeMap, Map<String, String> storeBankAccMap) {
        BigDecimal amt = BigDecimal.ZERO;
        if (NumberUtil.isNumber((CharSequence)importEntity.getTotalAmt())) {
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            if (!pattern.matcher(importEntity.getTotalAmt()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            }
            if (NumberUtil.isLess((BigDecimal)(amt = new BigDecimal(importEntity.getTotalAmt())), (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\uff0c\u4e0d\u80fd\u5c0f\u4e8e0"));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\u683c\u5f0f\u4e0d\u5bf9"));
        }
        if (accountMap.containsKey(importEntity.getAccCode())) {
            AccountDTO accountDTO = accountMap.get(importEntity.getAccCode());
            if (!StrUtil.equals((CharSequence)accountDTO.getState(), (CharSequence)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u672a\u6fc0\u6d3b"));
            }
            if (StrUtil.equals((CharSequence)adjustOrderSaveParam.getAdjType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode()) && amtMap.containsKey(importEntity.getAccCode()) && NumberUtil.isGreater((BigDecimal)amtMap.get(importEntity.getAccCode()), (BigDecimal)accountDTO.getAccountAvailableAmount())) {
                log.warn("{}, \u8c03\u51fa\u91d1\u989d({})\u5927\u4e8e\u8d26\u6237\u53ef\u7528\u91d1\u989d({})", new Object[]{importEntity.getAccCode(), amtMap.get(importEntity.getAccCode()), accountDTO.getAccountAvailableAmount()});
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u51fa\u91d1\u989d\u5927\u4e8e\u8d26\u6237\u53ef\u7528\u91d1\u989d"));
            }
            adjustOrderSaveParam.setAccCode(importEntity.getAccCode());
            adjustOrderSaveParam.setAccName(accountDTO.getAccountName());
            adjustOrderSaveParam.setTotalAmt(amt);
            adjustOrderSaveParam.setAccType(accountDTO.getAccountType());
            adjustOrderSaveParam.setAccountHolderName(accountDTO.getAccountHolderName());
            adjustOrderSaveParam.setAccountHolderCode(accountDTO.getAccountHolderCode());
            if (storeMap.containsKey(accountDTO.getAccountHolderCode())) {
                OrgStoreBaseRpcDTO orgStore = storeMap.get(accountDTO.getAccountHolderCode());
                if ("CLOSED".equals(orgStore.getStoreStatus())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8be5\u8d26\u6237\u7684\u95e8\u5e97\u5df2\u95ed\u5e97,\u65e0\u6cd5\u8c03\u6574"));
                }
                adjustOrderSaveParam.setStoredBankAcc(storeBankAccMap.get(orgStore.getStoredOuCode()));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u4e0d\u5b58\u5728"));
        }
    }

    private void checkImportMandatoryField(AdjustOrderImportEntity importEntity, List<String> errorList, int rowId) {
        if (StringUtils.isBlank((CharSequence)importEntity.getAccCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u8c03\u6574\u7c7b\u578b\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getTotalAmt())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjReasonName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u8c03\u6574\u539f\u56e0\u5fc5\u586b"));
        }
    }

    public void saveData(List<AdjustOrderSaveParam> saveList) {
        List<AdjustOrderDO> doList = AdjustOrderConvert.INSTANCE.paramsToDOs(saveList);
        this.flexFieldUtilService.handFlexFieldValueFeferenceList("ADJUST_ORDER", doList);
        this.adjustOrderRepo.saveAll(doList);
    }

    public void submit(List<AdjustOrderDO> doList) {
        doList.forEach(this.adjustOrderService::workflowAndGenerateAccountFlow);
    }

    public AdjustOrderImportServiceImpl(AccountRepoProc accountRepoProc, AdjustOrderRepo adjustOrderRepo, UdcProvider udcProvider, SysNumberGenerator sysNumberGenerator, AdjustOrderServiceImpl adjustOrderService, FlexFieldUtilService flexFieldUtilService, OrgStoreRpcService orgStoreRpcService, OrgOuRpcService orgOuRpcService, AdjustOrderSubmitJob adjustOrderSubmitJob) {
        this.accountRepoProc = accountRepoProc;
        this.adjustOrderRepo = adjustOrderRepo;
        this.udcProvider = udcProvider;
        this.sysNumberGenerator = sysNumberGenerator;
        this.adjustOrderService = adjustOrderService;
        this.flexFieldUtilService = flexFieldUtilService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.adjustOrderSubmitJob = adjustOrderSubmitJob;
    }
}

