package com.elitesland.fin.application.facade.vo.account;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
@ApiModel("详情传输类")
public class AccountRuleConfigQueryVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4212038342420493568L;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("适用单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDoc;
    private String optDocName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    private List<AccountRuleConfigDtlVO> accountRuleConfigDtlVoList;


}