package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "fin_payment_filed_info")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_filed_info", comment = "付款单扩展表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "付款单扩展表", description = "付款单扩展表")
@Where(clause = "delete_flag = 0")
public class PaymentOrderFiledDo extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8406325234498781930L;
    //门店编码
    @Column(name = "shop_code", columnDefinition = "varchar(40) comment '门店编码'")
    private String shopCode;
    //门店名称
    @Column(name = "shop_name", columnDefinition = "varchar(40) comment '门店名称'")
    private String shopName;
    //主表id
    @Column(name = "mas_id", columnDefinition = "bigint(40) comment '主表id'")
    private Long masId;
    //门店编码
    @Column(name = "apply_file", columnDefinition = "varchar(200) comment '支付凭证'")
    private String applyFile;

}
