package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_account_period")
@org.hibernate.annotations.Table(appliesTo = "fin_account_period", comment = "会计期间")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccountPeriodDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "account_period_code", columnDefinition = "varchar(20) comment '会计期间编码'")
    private String accountPeriodCode;

    @Column(name = "account_period_name", columnDefinition = "varchar(32) comment '会计期间名称'")
    private String accountPeriodName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;
}
