package com.elitesland.fin.application.facade.vo.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("付款单返回")
public class PaymentOrderPageRespVo implements Serializable {
    private static final long serialVersionUID = 1801736065058528178L;
    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("应付单类型定义ID")
    private Long apTypeId;

    @ApiModelProperty("应付单类型名称")
    private String apTypeName;
    @ApiModelProperty("应付单类型代码")
    @SysCode(sys = "yst-fin", mod = "AP_TYPE")
    private String apTypeCode;
    private String apTypeCodeName;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("付款单类型代码")
    @SysCode(sys = "yst-fin", mod = "PAYORDER_TYPE")
    private String payTypeCode;
    private String payTypeCodeName;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("币种编码")
    @SysCode(sys = "yst-fin", mod = "CURR")
    private String currCode;
    private String currCodeName;

    @ApiModelProperty("经办人")
    private String operator;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "PAYORDER_STATE")
    private String orderState;
    private String orderStateName;
    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际支付金额")
    private BigDecimal realPayAmt;

    @ApiModelProperty("实际支付金额(本位币)")
    private BigDecimal realPayCurAmt;

    @ApiModelProperty("预计付款日期")
    private LocalDateTime apDate;

    @ApiModelProperty("是否预付")
    private Boolean apFlag;

    @ApiModelProperty("创建人名称")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
//
//    @ApiModelProperty("修改人名称")
//    private String updater;
//
//    @ApiModelProperty("修改时间")
//    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审核拒绝原因")
    private String auditRejection;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("本位币名称")
    private String localCurrCode;

    @ApiModelProperty("本位币编码")
    private String localCurrName;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("剩余未核销金额")
    private BigDecimal unVerAmt;

//    @ApiModelProperty("锁版本")
//    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;
    //门店编码
    @ApiModelProperty("门店编码")
    private String shopCode;
    //门店名称
    @ApiModelProperty("门店名称")
    private String shopName;
    //主表id
    @ApiModelProperty("主表id")
    private Long masId;
    //支付凭证
    @ApiModelProperty("支付凭证")
    private String applyFile;

    @ApiModelProperty("支付凭证")
    private List<String> applyFileS;
    @ApiModelProperty("明细集合")
    private List<PayOrderDtlDTO> payOrderDtlRpcDTOList;
}
