package com.elitesland.fin.application.web.saobei;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiTradeParamVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiTradeRespVO;
import com.elitesland.fin.application.service.saobei.SaobeiAccountService;
import com.saobei.open.sdk.model.requst.allocate.SaobeiDoTransRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiQueryOrderRequest;
import com.saobei.open.sdk.model.response.allocate.SaobeiDoTransResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiQueryOrderResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "扫呗支付接口")
@RestController
@RequestMapping(value = "/saobei", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class SaobeiController {
    private final SaobeiAccountService saobeiAccountService;

    @ApiOperation("扫呗 - CBK账户中心")
    @GetMapping(value = "/centerlink/{accountNo}")
    public ApiResult<String> centerlink(@PathVariable("accountNo") String accountNo) throws Exception {
        return ApiResult.ok(saobeiAccountService.centerlink(accountNo));
    }

    @ApiOperation("扫呗 - 查询CBK账户余额")
    @GetMapping(value = "/balance/{accountNo}")
    public ApiResult<String> getBalance(@PathVariable("accountNo") String accountNo) throws Exception {
        return ApiResult.ok(saobeiAccountService.getBalance(accountNo));
    }

    @ApiOperation("扫呗 - 分账申请")
    @PostMapping(value = "/dotrans")
    public ApiResult<SaobeiDoTransResponse> dotrans(@RequestBody SaobeiDoTransRequest request) throws Exception {
        return ApiResult.ok(saobeiAccountService.dotrans(request));
    }

    @ApiOperation("扫呗 - 分账列表查询")
    @PostMapping(value = "/queryTrades")
    public ApiResult<SaobeiTradeRespVO> queryTrades(@RequestBody SaobeiTradeParamVO paramVO) throws Exception {
        return ApiResult.ok(saobeiAccountService.queryTradesByDate(paramVO));
    }

    @ApiOperation("扫呗 - 分账详情查询")
    @PostMapping(value = "/queryOrder")
    public ApiResult<SaobeiQueryOrderResponse> queryTrades(@RequestBody SaobeiQueryOrderRequest request) throws Exception {
        return ApiResult.ok(saobeiAccountService.queryOrder(request));
    }

}
