package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_account_engine")
@org.hibernate.annotations.Table(appliesTo = "fin_account_engine", comment = "会计引擎")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccountEngineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "event_table", columnDefinition = "varchar(32) comment '事件表单名称'")
    private String eventTable;
    @Column(name = "event_table_id", columnDefinition = "bigint comment '事件表单ID'")
    private Long eventTableId;
    @Column(name = "column_company", columnDefinition = "varchar(32) comment '公司字段'")
    private String columnCompany;

    @Column(name = "column_doc_num", columnDefinition = "varchar(32) comment '单据编码字段'")
    private String columnDocNum;

    @Column(name = "journal_host", columnDefinition = "varchar(32) comment '主机'")
    private String journalHost;

    @Column(name = "journal_port", columnDefinition = "varchar(32) comment '端口'")
    private String journalPort;

    @Column(name = "journal_user", columnDefinition = "varchar(32) comment '用户名'")
    private String journalUser;

    @Column(name = "journal_password", columnDefinition = "varchar(32) comment '密码'")
    private String journalPassword;

    @Column(name = "journal_database", columnDefinition = "varchar(32) comment '数据库名称'")
    private String journalDatabase;

    @Column(name = "journal_table", columnDefinition = "varchar(32) comment '主表'")
    private String journalTable;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;
}
