package com.elitesland.fin.infr.dto.inputinv;

import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 11:14
 */
@Data
public class InputInvDTO implements Serializable {

    private static final long serialVersionUID = 5074791963350772187L;
    private Long id;

    private String sourceNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private BigDecimal taxRate;

    private String invRegNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String openBank;

    private String bankAccount;

    private String suppAddress;

    private String suppRemark;

    private Long suppId;

    private String suppName;

    private String suppCode;

    private String suppTel;

    private String invUser;

    private String recUser;

    private String revUser;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private String auditRejection;

    private String createMode;

    private String taxNumber;

    private String remark;

    private String creator;

    private LocalDateTime createTime;

    private String updater;

    private LocalDateTime modifyTime;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<InputInvDtlDTO> dtlDTOList;

    @ApiModelProperty("invNo")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("红蓝票类型")
    private String redBlueType;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("应付单号")
    private String apOrderNo;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("未税金额")
    private BigDecimal untaxedAmt;


    @ApiModelProperty("税额")
    private BigDecimal taxAmt;


    @ApiModelProperty("发票校验码")
    private String invCheckCode;


    @ApiModelProperty("发票查验状态,UDC")
    private String invVerifyStatus;


    @ApiModelProperty("附件标识")
    private String invFileCode;
}
