package com.elitesland.fin.application.convert.paytype;


import com.elitesland.fin.application.facade.param.paytype.PayTypeSaveParam;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.domain.entity.paytype.PayType;
import com.elitesland.fin.domain.entity.paytype.PayTypeDO;
import com.elitesland.fin.infr.dto.paytype.PayTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface PayTypeConvert {

    PayTypeConvert INSTANCE = Mappers.getMapper(PayTypeConvert.class);

    PagingVO<PayTypeVO> convertPage(PagingVO<PayTypeDTO> param);

    PayTypeDO convert(PayType payType);

    PayType convert(PayTypeSaveParam param);

    List<PayTypeVO> dtoToVo(List<PayTypeDTO> payTypeDTOS);

    //付款单类型ID映射付款单payTypeId  忽略主键ID映射
    @Mapping(source = "id", target = "payTypeId")
    @Mapping(target = "id",ignore = true)
    PayOrderVO typeToOrder(PayTypeDTO payTypeDTO);

}
