package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class QuantitySupplyZeroConverter extends Converter<Long, String, String> {
    private static final SystemRpcService systemRpcService = SpringContextHolder.getBean(SystemRpcService.class);
    
    @Override
    public String convert(Long value) {
        if(value == null) {
            value = 0L;
        }
        if (baseValue == null) {
            return value.toString();
        }
        
        return value + "." + baseValue;
    }
    
    @Override
    public synchronized String initBaseValue() {
        if(baseValue != null) {
            return baseValue;
        }
        return baseValue = getZeroString();
    }
    
    @Override
    public synchronized String refreshBaseValue() {
        return baseValue = getZeroString();
    }
    
    private String getZeroString() {
        SysSettingVO quantityDecimalPlace = systemRpcService.findSysSettingByNo("QUANTITY_DECIMAL_PLACE");
        Integer zeroNumber = 0;
        if (quantityDecimalPlace != null
            && quantityDecimalPlace.getSettingVal() != null
            && !quantityDecimalPlace.getSettingVal().equals("")) {
            zeroNumber = Integer.parseInt(quantityDecimalPlace.getSettingVal());
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < zeroNumber; i++) {
            res.append("0");
        }
        return res.toString();
    }
}
