package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.service.report.IpvCommonService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_IPV_INOVICE_EXPORT;

@Service
@AllArgsConstructor
public class FinIpvInvoiceExportServiceImpl implements DataExport<IpvRespVO, IpvInvoicePageParam> {
    private final IpvCommonService ipvCommonService;

    @Override
    public String getTmplCode() {
        return FIN_IPV_INOVICE_EXPORT;
    }

    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_IPV_INVOICE_LIST, businessObjectType = FinBusinessObjectConstant.FIN_IPV_INVOICE,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "IPV账单导出",operationCode = FinBusinessObjectConstant.FIN_IPV_INVOICE_EXPORT_DEFAULT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<IpvRespVO> executeExport(IpvInvoicePageParam queryParam) {
        return ipvCommonService.page(queryParam);
    }

    @Override
    public Integer pageSize() {
        return 1000;
    }
}
