package com.elitesland.fin.application.web.workflow;

import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.fin.application.service.workflow.adjust.FinAdjustOrderProcessService;
import com.elitesland.fin.common.CallBackPathConstant;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;


@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(CallBackPathConstant.FIN_ADJUST_PATH)
public class FinAdjustOrderController implements WorkflowCallBack {

    private final FinAdjustOrderProcessService finAdjustOrderProcessService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人:{}", payload.toString());
        return WorkflowResult.success(new ArrayList<>());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("状态修改回调:{}",payload.toString());
        var request = HttpServletUtil.currentRequest();
        var headers = getHeaders(request);
        log.info("请求头：{}", headers);
        finAdjustOrderProcessService.processStatusChange(payload.getBusinessKey(), payload.getProcInstStatus(),
                payload.getCommentInfo());
        return WorkflowResult.success(null);
    }

    public static MultiValueMap<String, String> getHeaders(HttpServletRequest request) {
        var names = request.getHeaderNames();
        MultiValueMap<String, String> headerMap = new LinkedMultiValueMap<>(64);
        while (names.hasMoreElements()) {
            var name = names.nextElement();
            var values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headerMap.add(name, values.nextElement());
            }
        }
        return headerMap;
    }
}
