package com.elitesland.fin.domain.entity.report;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "fin_ipv_invoice")
@org.hibernate.annotations.Table(appliesTo = "fin_ipv_invoice", comment = "IPV账单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "IPV账单", description = "IPV账单")
@Where(clause = "delete_flag = 0")
public class IpvInvoiceDO extends BaseModel implements Serializable {

    @ApiModelProperty("应付单号")
    @Comment("应付单号")
    @Column()
    private String apOrderNo;

    @ApiModelProperty("收退货单号")
    @Comment("收退货单号")
    @Column()
    private String sourceDocNo;

    @ApiModelProperty("收退货行号")
    @Comment("收退货行号")
    @Column()
    private Integer sourceLineNo;

    @ApiModelProperty("公司ID")
    @Comment("公司ID")
    @Column()
    @BusinessParam(relatedBusinessObject =  SupportBusinessObjectConstants.SUPPORT_OU)
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Comment("公司编码")
    @Column()
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @Comment("公司名称")
    @Column()
    private String ouName;

    @ApiModelProperty("供应商ID")
    @Comment("供应商ID")
    @Column()
    private Long suppId;

    @ApiModelProperty("供应商编码")
    @Comment("供应商编码")
    @Column()
    private String suppCode;

    @ApiModelProperty("供应商名称")
    @Comment("供应商名称")
    @Column()
    private String suppName;

    @ApiModelProperty("仓库ID")
    @Comment("仓库ID")
    @Column()
    private Long whId;

    @ApiModelProperty("仓库编码")
    @Comment("仓库编码")
    @Column()
    private String whCode;

    @ApiModelProperty("仓库名称")
    @Comment("仓库名称")
    @Column()
    private String whName;

    @ApiModelProperty("商品ID")
    @Comment("商品ID")
    @Column()
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Comment("商品编码")
    @Column()
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Comment("商品名称")
    @Column()
    private String itemName;

    @ApiModelProperty("商品分类")
    @Comment("商品分类")
    @Column()
    private String itemType;

    @ApiModelProperty("记账日期")
    @Comment("记账日期")
    @Column()
    private LocalDateTime finDate;

    @ApiModelProperty("数量")
    @Comment("数量")
    @Column()
    private BigDecimal apQty;

    @ApiModelProperty("单位")
    @Comment("单位")
    @Column()
    private String uom;

    @Column(name = "account_period", columnDefinition = "varchar(32) comment '会计期间'")
    private String accountPeriod;

    @ApiModelProperty("当期销售出库数量")
    @Comment("当期销售出库数量")
    @Column()
    private BigDecimal saleQty;

    @ApiModelProperty("销售占比")
    @Comment("销售占比")
    @Column()
    private BigDecimal saleRatio;

    @ApiModelProperty("IPV")
    @Comment("IPV")
    @Column()
    private BigDecimal ipv;

    @ApiModelProperty("销售占比金额")
    @Comment("销售占比金额")
    @Column()
    private BigDecimal ratioAmt;

    @ApiModelProperty("小类编码")
    @Comment("小类编码")
    @Column()
    private String smallCateCode;

    @ApiModelProperty("小类名称")
    @Comment("小类名称")
    @Column()
    private String smallCateName;

    @ApiModelProperty("应付单行ID")
    @Comment("应付单行ID")
    @Column()
    private Long apOrderDid;
}
