package com.elitesland.fin.entity.invoice;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


@Entity
@Table(name = "tax_account_mapping")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "tax_account_mapping", comment = "税号和开票账户关系表")
@Data
@Accessors(chain = true)
@ApiModel(value = "tax_account_mapping", description = "税号和开票账户关系表")
public class TaxAccountMappingDO implements Serializable {

    /**
     * 税号
     */
    @Id
    @Column(name = "tax_no", columnDefinition = " VARCHAR(20) comment '税号'")
    private String taxNo;

    /**
     * 开票账户
     */
    @Column(name = "account_no", columnDefinition = " VARCHAR(50) comment '开票账户")
    private String accountNo;
}
