package com.elitesland.fin.infinity.aisino.vo.param;
import com.alibaba.fastjson.annotation.JSONField;

import lombok.Data;

/**
 * 红字发票确认单信息实体类
 * 用于存储红字发票确认单的相关信息
 * Created by lance on 2025/8/11.
 */
@Data
public class AisinoRedInvoiceParam {

    /**
     * 红字确认单UUID
     * 唯一标识红字确认单的全局唯一标识符
     */
    @JSONField(name = "UUID")
    private String UUID;

    /**
     * 发票请求流水号
     * 生成规则：税号 + 随机数，长度为30位的唯一值
     * 用于唯一标识一次发票开具请求
     */
    @JSONField(name = "FPQQLSH")
    private String FPQQLSH;

    /**
     * 对应蓝字发票号码
     * 记录需要冲红的原始蓝字发票号码
     */
    @JSONField(name = "YFPHM")
    private String YFPHM;

    /**
     * 红字确认单编号
     * 红字发票确认单的业务编号
     */
    @JSONField(name = "HZFPXXQRDBH")
    private String HZFPXXQRDBH;

    /**
     * 是否纸质发票
     * 标识该发票是否为纸质发票
     * Y-是，N-否
     */
    @JSONField(name = "SFZZFP")
    private String SFZZFP ;

    /**
     * 纸质发票号码
     * 当为纸质发票时，记录具体的发票号码
     */
    @JSONField(name = "ZZFPHM")
    private String ZZFPHM;

    /**
     * 纸质发票代码
     * 当为纸质发票时，记录对应的发票代码
     */
    @JSONField(name = "FPDM")
    private String FPDM;

    /**
     * 发票种类代码
     * 标识发票的种类类型
     */
    @JSONField(name = "FPZLDM")
    private String FPZLDM;

    /**
     * 销售方纳税人识别号
     * 记录销售方的税务登记号码
     */
    @JSONField(name = "XSFNSRSBH")
    private String XSFNSRSBH;

    /**
     * 特定要素类型代码
     * 用于标识特定业务场景下的要素分类
     */
    @JSONField(name = "TDYSLXDM")
    private String TDYSLXDM;


}
