package com.elitesland.fin.provider.bip.params;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 收款单.
 * <p>
 * 取值：扫呗流水、储值流水、账户调整但
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/23 周三
 */
@Getter
@Setter
public class BipFinReceiptDTO implements Serializable {
    private static final long serialVersionUID = -4752078462919596333L;

    /**
     * 收款公司编码
     */
    @JsonProperty(value = "pk_org")
    private String ouCode;

    /**
     * 单据日期
     */
    @JsonProperty(value = "billdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime docDate;

    /**
     * 往来对象
     * <p>
     * 0=客户,1=供应商
     * <p>
     * 固定传0
     */
    @JsonProperty(value = "objtype")
    private Integer objType;

    /**
     * 客户编码
     */
    @JsonProperty(value = "customer")
    private String customerCode;

    /**
     * 结算方式
     * <p>
     * 扫呗账户/储值账户；
     */
    @JsonProperty(value = "pk_balatype")
    private String settleType;

    /**
     * 收款账户
     */
    @JsonProperty(value = "ar_recaccount")
    private String receiveAccount;

    /**
     * CBK账户
     */
    @JsonProperty(value = "def7")
    private String cbkAccount;

    /**
     * 币种
     * <p>
     * CNY
     */
    @JsonProperty(value = "pk_currtype")
    private String currCode;

    /**
     * 合计金额
     */
    @JsonProperty(value = "money")
    private BigDecimal amt;

    /**
     * 汇率
     * <p>
     * 默认1
     */
    @JsonProperty(value = "rate")
    private String currRate;

    /**
     * 合计金额(本币)
     */
    @JsonProperty(value = "local_money")
    private BigDecimal amt1;

    /**
     * 集团本币汇率
     * <p>
     * 不传值
     */
    @JsonProperty(value = "grouprate")
    private BigDecimal groupCurrRate;

    /**
     * 集团本币金额
     * <p>
     * 不传值
     */
    @JsonProperty(value = "grouplocal")
    private BigDecimal groupAmt;

    /**
     * 全局本币汇率
     * <p>
     * 不传值
     */
    @JsonProperty(value = "globalrate")
    private BigDecimal globalCurrRate;

    /**
     * 全局本币金额
     * <p>
     * 不传值
     */
    @JsonProperty(value = "globallocal")
    private BigDecimal globalAmt;

    /**
     * 收款类型
     */
    @JsonProperty(value = "pk_tradetype")
    private String receiptType;

    /**
     * 制单人
     */
    @JsonProperty(value = "billmaker")
    private String creatorRoot;

    /**
     * 制单人名称
     */
    @JsonProperty(value = "def1")
    private String creator;

    /**
     * 储值单号/流水号
     */
    @JsonProperty(value = "def2")
    private String docNo;

    /**
     * 备注
     */
    @JsonProperty(value = "def9")
    private String remark;

    /**
     * 明细
     */
    @JsonProperty(value = "items")
    private List<Detail> detailList;

    @Getter
    @Setter
    public static class Detail implements Serializable {
        private static final long serialVersionUID = -4148422940899474487L;

        /**
         * 收款性质
         * <p>
         * 0=应收款,1=预收款
         */
        @JsonProperty(value = "prepay")
        private Integer prepay;

        /**
         * 收款业务类型
         * <p>
         * 传编码，货款/科技费/营销费/服务费
         */
        @JsonProperty(value = "pk_recpaytype")
        private String businessType;

        /**
         * 往来对象
         * <p>
         * 传编码，0=客户,1=供应商
         * <p>
         * 固定传0
         */
        @JsonProperty(value = "objtype")
        private Integer objType;

        /**
         * 客户编码
         */
        @JsonProperty(value = "customer")
        private String customerCode;

        /**
         * 收款账户
         */
        @JsonProperty(value = "ar_recaccount")
        private String receiveAccount;

        /**
         * 币种
         * <p>
         * 传CNY
         */
        @JsonProperty(value = "pk_currtype")
        private String currCode;

        /**
         * 金额
         */
        @JsonProperty(value = "money_cr")
        private BigDecimal money;

        /**
         * 汇率
         * <p>
         * 默认1
         */
        @JsonProperty(value = "rate")
        private String currRate;

        /**
         * 金额(本币)
         */
        @JsonProperty(value = "local_money_cr")
        private BigDecimal amt;

        /**
         * 集团本币汇率
         * <p>
         * 不传
         */
        @JsonProperty(value = "grouprate")
        private BigDecimal groupCurrRate;

        /**
         * 集团本币金额
         * <p>
         * 不传
         */
        @JsonProperty(value = "groupdebit")
        private BigDecimal groupAmt;

        /**
         * 集团本币汇率
         * <p>
         * 不传
         */
        @JsonProperty(value = "globalrate")
        private BigDecimal globalCurrRate;

        /**
         * 集团本币金额
         * <p>
         * 不传
         */
        @JsonProperty(value = "globaldebit")
        private BigDecimal globalAmt;

        /**
         * 贷方数量
         * <p>
         * 不传
         */
        @JsonProperty(value = "quantity_de")
        private BigDecimal qty;

        /**
         * 单价
         * <p>
         * 不传
         */
        @JsonProperty(value = "price")
        private BigDecimal price;

        /**
         * 税率编码
         * <p>
         * 不传
         */
        @JsonProperty(value = "taxcodeid")
        private String taxRateCode;

        /**
         * 报货单号
         */
        @JsonProperty(value = "def2")
        private String rootDocNo;
    }
}
