package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookOuConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookOuDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookParam;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSetOfBookDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinSetOfBookRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;

    private final QFinSetOfBookDO qFinSetOfBookDO = QFinSetOfBookDO.finSetOfBookDO;

    public PagingVO<FinSetOfBookDTO> page(FinSetOfBookParam finSetOfBookParam) {
        Predicate where = where(finSetOfBookParam);
        JPAQuery<FinSetOfBookDTO> query = select(FinSetOfBookDTO.class).where(ExpressionUtils.allOf(where));
        finSetOfBookParam.fillOrders(query, qFinSetOfBookDO);
        finSetOfBookParam.setPaging(query);


        List<FinSetOfBookDTO> finSetOfBookDTOList = query.fetch();

        List<Long> ids = finSetOfBookDTOList.stream().map(FinSetOfBookDTO::getId).collect(Collectors.toList());

        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = FinSetOfBookLineConvert.INSTANCE.DOToDTO(finSetOfBookLineRepo.findAllByMasIdIn(ids));
        List<FinSetOfBookOuDTO> finSetOfBookOuDTOList = FinSetOfBookOuConvert.INSTANCE.DOToDTO(finSetOfBookOuRepo.findAllByMasIdIn(ids));

        for (FinSetOfBookDTO finSetOfBookDTO : finSetOfBookDTOList) {

            finSetOfBookDTO.setDimenDetailList(finSetOfBookLineDTOList.stream()
                    .filter(finSetOfBookLineDTO -> finSetOfBookDTO.getId().equals(finSetOfBookLineDTO.getMasId()))
                    .collect(Collectors.toList()));

            finSetOfBookDTO.setOuDetailList(finSetOfBookOuDTOList.stream()
                    .filter(finSetOfBookOuDTO -> finSetOfBookDTO.getId().equals(finSetOfBookOuDTO.getMasId()))
                    .collect(Collectors.toList()));
        }

        return PagingVO.<FinSetOfBookDTO>builder()
                .total(query.fetchCount())
                .records(finSetOfBookDTOList)
                .build();
    }

    public List<FinSetOfBookDTO> selectFinSet(FinSetOfBookParam finSetOfBookParam) {
        Predicate where = where(finSetOfBookParam);
        JPAQuery<FinSetOfBookDTO> query = select(FinSetOfBookDTO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(qFinSetOfBookDO.createTime.desc());
        List<FinSetOfBookDTO> fetch = query.fetch();
        return fetch;
    }


    private Predicate where(FinSetOfBookParam finSetOfBookParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finSetOfBookParam.getId() != null, qFinSetOfBookDO.id, finSetOfBookParam.getId())
                .andLike(StringUtils.isNotEmpty(finSetOfBookParam.getSobCode()), qFinSetOfBookDO.sobCode, StringUtil.buildLikeString(finSetOfBookParam.getSobCode()))
                .andLike(StringUtils.isNotEmpty(finSetOfBookParam.getSobName()), qFinSetOfBookDO.sobName, StringUtil.buildLikeString(finSetOfBookParam.getSobName()))
                .andEq(finSetOfBookParam.getStatus() != null, qFinSetOfBookDO.status, finSetOfBookParam.getStatus())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinSetOfBookDO.id,
                qFinSetOfBookDO.sobCode,
                qFinSetOfBookDO.sobName,
                qFinSetOfBookDO.accountPeriodCode,
                qFinSetOfBookDO.accountPeriodName,
                qFinSetOfBookDO.currCode,
                qFinSetOfBookDO.currName,
                qFinSetOfBookDO.status,

                qFinSetOfBookDO.createTime,
                qFinSetOfBookDO.creator,
                qFinSetOfBookDO.modifyTime,
                qFinSetOfBookDO.updater
        )).from(qFinSetOfBookDO);
    }

    public FinSetOfBookDO findById(Long id) {

        Optional<FinSetOfBookDO> finSetOfBookDOOptional = finSetOfBookRepo.findById(id);
        Assert.isTrue(finSetOfBookDOOptional.isPresent(),"账套不存在");

        return finSetOfBookDOOptional.get();
    }


    public FinSetOfBookDO findBySobCode(String sobCode) {

        List<FinSetOfBookDO> finSetOfBookDOList = finSetOfBookRepo.findAllBySobCode(sobCode);

        if (CollectionUtils.isNotEmpty(finSetOfBookDOList)) {
            Assert.equals(finSetOfBookDOList.size(), 1, "查询到多条账套");
            return finSetOfBookDOList.get(0);
        }
        return null;
    }


    public FinSetOfBookDO findBySobCodeAndStatus(String sobCode, String status) {

        List<FinSetOfBookDO> finSetOfBookDOList = finSetOfBookRepo.findAllBySobCodeAndStatus(sobCode, status);

        if (CollectionUtils.isNotEmpty(finSetOfBookDOList)) {
            Assert.equals(finSetOfBookDOList.size(), 1, "查询到多条账套");
            return finSetOfBookDOList.get(0);
        }
        return null;
    }


}
