/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPayHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyPayHeadService;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayHeadDO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepo;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class FinApPayVerApplyPayHeadServiceImpl
implements FinApPayVerApplyPayHeadService {
    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;
    private final FinApPayVerApplyPayHeadRepo finApPayVerApplyPayHeadRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public Long create(Long masId, FinApPayVerApplyPayHeadSaveDTO param) {
        List<PayOrderDTO> payOrderDTOList;
        HashMap payOrderMap;
        PayOrderDTO payOrderDTO;
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        FinApPayVerApplyPayHeadDO entity = FinApPayVerApplyPayHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        if ((StringUtils.isBlank((CharSequence)entity.getInOutCust()) || StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode())) && Objects.nonNull(payOrderDTO = (PayOrderDTO)(payOrderMap = CollectionUtil.isEmpty(payOrderDTOList = this.payOrderRepoProc.selectInOutCustByPayOrderNo(Collections.singletonList(entity.getPayOrderNo()))) ? new HashMap() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1))).get(entity.getPayOrderNo()))) {
            String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? payOrderDTO.getInOutCust() : entity.getInOutCust();
            String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
            entity.setInOutCust(inOutCust);
            entity.setRelevanceOuCode(relevanceOuCode);
        }
        this.flexFieldUtilService.handFlexFieldValueFeference("FIN_AP_PAY_VER_APPLY_PAY_HEAD", (Object)entity);
        return ((FinApPayVerApplyPayHeadDO)((Object)this.finApPayVerApplyPayHeadRepo.save((Object)entity))).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finApPayVerApplyPayHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyPayHeadVO> finApPayVerApplyPayHeadVOList = this.finApPayVerApplyPayHeadRepoProc.listByMasIds(masIds).stream().map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplyPayHeadVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyPayHeadVOList.stream().map(FinApPayVerApplyPayHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyPayHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finApPayVerApplyPayHeadVOList;
    }

    @Override
    public List<FinApPayVerApplyPayHeadVO> listByIds(FinApPayVerApplyQuery query, Collection<Long> ids) {
        return this.finApPayVerApplyPayHeadRepoProc.listByIds(query, ids).stream().map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO).collect(Collectors.toList());
    }

    public FinApPayVerApplyPayHeadServiceImpl(FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc, FinApPayVerApplyPayHeadRepo finApPayVerApplyPayHeadRepo, FlexFieldUtilService flexFieldUtilService, PayOrderRepoProc payOrderRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.finApPayVerApplyPayHeadRepoProc = finApPayVerApplyPayHeadRepoProc;
        this.finApPayVerApplyPayHeadRepo = finApPayVerApplyPayHeadRepo;
        this.flexFieldUtilService = flexFieldUtilService;
        this.payOrderRepoProc = payOrderRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

