package com.elitesland.fin.domain.service.AccountFlow;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.account.AccountDomainService;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
@AllArgsConstructor
public class AccountFlowDomainServiceImpl implements AccountFlowDomainService{
    private FlexFieldUtilService flexFieldUtilService;
    private AccountFlowRepo accountFlowRepo;
    private AccountRepoProc accountRepoProc;
    private AccountDomainService accountDomainService;
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public AccountFlowDO saveAccountFlow(AccountFlowParam accountFlowParam) {
        checkMandatoryField(accountFlowParam);
        AccountFlowDO accountFlowDO = AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam);
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.ACCOUNT_FLOW, accountFlowDO);
        return accountFlowRepo.save(accountFlowDO);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void updateAccountBalanceAndGenerateAccountFlow(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            AccountFlowParam accountFlowParam=item;
            AccountVO oldAccountVO = accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals(oldAccountVO.getState(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "账户已经被禁用");
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                int res = accountDomainService.updateAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("账户流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("账户流水生成,更新账户金额失败,可用金额不足");
                    throw new BusinessException("账户流水生成,更新账户金额失败,可用金额不足");
                }
            }else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                int res = accountDomainService.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("账户增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("账户增加流水生成,更新账户金额失败!");
                    throw new BusinessException("账户增加流水生成,更新账户金额失败!");
                }
            }else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                int res = accountDomainService.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("账户扣减流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("账户扣减流水生成,更新账户金额失败!");
                    throw new BusinessException("账户扣减流水生成,更新账户金额失败!");
                }
            }else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                int res = accountDomainService.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("账户占用释放流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("账户占用释放流水生成,更新账户金额失败!");
                    throw new BusinessException("账户占用释放流水生成,更新账户金额失败!");
                }
            }else {
                throw new BusinessException("账户未匹配到交易类型!");
            }

            AccountVO newAccountVO = accountRepoProc.get(oldAccountVO.getId());
            if(newAccountVO==null){
                log.error("账户流水生成,查询更新后账户信息失败");
                throw new BusinessException("账户流水生成,查询更新后账户信息失败");
            }
            //更新审批中的流水的状态
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            //accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            //更新流水单状态
            SysUserDTO user = getUser();
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName(FinConstant.SYSTEM);
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            TransactionStatus transactionStatus1 = TransactionAspectSupport.currentTransactionStatus();
            //保存流水
            //创建账户流水
            AccountFlowDO accountFlowDO = saveAccountFlow(accountFlowParam);
            TransactionStatus transactionStatus2 = TransactionAspectSupport.currentTransactionStatus();
            accountFlowParam.setId(accountFlowDO.getId());
        });
    }
    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }
    private void checkMandatoryField(AccountFlowParam param) {
        if (StringUtils.isBlank(param.getAccountType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "账户类型为空!");
        }
        if (StringUtils.isBlank(param.getSourceDoc())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "来源单据为空!");
        }
        if (StringUtils.isBlank(param.getSourceNo())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "来源单号为空!");
        }
        if (StringUtils.isBlank(param.getTransactionType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "交易类型为空!");
        }
        if (Objects.isNull(param.getAmount())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "发生金额为空!");
        }
        if (Objects.isNull(param.getTransactionTime())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "交易日期为空!");
        }
        if (StringUtils.isBlank(param.getAccountCode())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "账户编码为空!");
        }
        if (StringUtils.isBlank(param.getAccountName())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "账户名称为空!");
        }
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void saveAccountFlowList(List<AccountFlowParam> accountFlowParams) {
        accountFlowParams.stream().forEach(v->{
            AccountFlowDO accountFlowDO=saveAccountFlow(v);
            v.setId(accountFlowDO.getId());
        });
    }
}
