package com.elitesland.fin.infr.repo.arorder;

import com.elitesland.fin.domain.entity.arorder.QArOrderDtlRecordDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/28
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ArOrderDtlRecordRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDtlRecordDO qArOrderDtlRecordDO = QArOrderDtlRecordDO.arOrderDtlRecordDO;

    public void updateDeleteFlagByMasId(List<Long> masIds) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDtlRecordDO)
                .set(qArOrderDtlRecordDO.deleteFlag, 1)
                .where(qArOrderDtlRecordDO.masId.in(masIds));
        jpaUpdateClause.execute();
    }

}
