package com.elitesland.fin.repo.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import com.elitesland.fin.entity.account.QAccountSnapshotDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public class AccountSnapshotRepoProc extends BaseRepoProc<AccountSnapshotDO> {

    private final static QAccountSnapshotDO qAccountSnapshotDO = QAccountSnapshotDO.accountSnapshotDO;

    protected AccountSnapshotRepoProc() {
        super(qAccountSnapshotDO);
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                        qAccountSnapshotDO.id,
                        qAccountSnapshotDO.accountName,
                        qAccountSnapshotDO.accountCode,
                        qAccountSnapshotDO.accountType,
                        qAccountSnapshotDO.state,
                        qAccountSnapshotDO.createTime,
                        qAccountSnapshotDO.creator,
                        qAccountSnapshotDO.accountOccupancyAmount,
                        qAccountSnapshotDO.accountAmount.subtract(qAccountSnapshotDO.accountOccupancyAmount).as("accAvaAmt"),
                        qAccountSnapshotDO.accountAmount,
                        qAccountSnapshotDO.accountAvailableAmount,
                        qAccountSnapshotDO.secOuCode,
                        qAccountSnapshotDO.secOuName,
                        qAccountSnapshotDO.snapshotTime,
                        qAccountSnapshotDO.accountHolderName,
                        qAccountSnapshotDO.accountHolderCode,
                        qAccountSnapshotDO.remark,
                        qAccountSnapshotDO.extensionInfo
                )
        ).from(qAccountSnapshotDO);
    }

    public PagingVO<AccountSnapshotVo> querySnapshot(AccountSnapshotParam param) {

        Predicate predicate = commonBuilder(param).build();
        Predicate predicate2 = whereAccountSnapshot(param);
        JPAQuery<AccountSnapshotVo> query = select(AccountSnapshotVo.class).where(predicate).where(predicate2);
        //数据权限
        BusinessSecurityUtil.where(query, AccountSnapshotDO.class);
        param.setPaging(query);
        param.fillOrders(query, qAccountSnapshotDO);
        List<AccountSnapshotVo> fetch = query.fetch();

        return PagingVO.<AccountSnapshotVo>builder()
                .total(query.fetchCount())
                .records(fetch)
                .build();
    }

    private PredicateBuilder commonBuilder(AccountSnapshotParam param) {
        return PredicateBuilder.builder()
                .andIn(CollectionUtil.isNotEmpty(param.getIds()), qAccountSnapshotDO.id, param.getIds())
                .andLike(StrUtil.isNotBlank(param.getAccountHolderName()), qAccountSnapshotDO.accountHolderName, param.getAccountHolderName())
                .andLike(StrUtil.isNotBlank(param.getAccountHolderCode()), qAccountSnapshotDO.accountHolderCode, param.getAccountHolderCode())
                .andLike(StrUtil.isNotBlank(param.getAccountCode()), qAccountSnapshotDO.accountCode, param.getAccountCode())
                .andLike(StrUtil.isNotBlank(param.getAccountName()), qAccountSnapshotDO.accountName, param.getAccountName())
                .andEq(StrUtil.isNotBlank(param.getAccountType()), qAccountSnapshotDO.accountType, param.getAccountType())
                .andGoe(ObjectUtil.isNotNull(param.getSnapshotStartTime()), qAccountSnapshotDO.snapshotTime, param.getSnapshotStartTime())
                .andLoe(ObjectUtil.isNotNull(param.getSnapshotEndTime()), qAccountSnapshotDO.snapshotTime, param.getSnapshotEndTime());
    }

    private Predicate whereAccountSnapshot(AccountSnapshotParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(param.getAccountHolderNameList())){
            predicates.add(qAccountSnapshotDO.accountHolderName.in(param.getAccountHolderNameList()));
        }
        if(CollectionUtils.isNotEmpty(param.getAccountHolderCodeList())){
            predicates.add(qAccountSnapshotDO.accountHolderCode.in(param.getAccountHolderCodeList()));
        }
        if(CollectionUtils.isNotEmpty(param.getAccountCodeList())){
            predicates.add(qAccountSnapshotDO.accountCode.in(param.getAccountCodeList()));
        }
        if(CollectionUtils.isNotEmpty(param.getAccountNameList())){
            predicates.add(qAccountSnapshotDO.accountName.in(param.getAccountNameList()));
        }
        if(CollectionUtils.isNotEmpty(param.getAccountTypeList())){
            predicates.add(qAccountSnapshotDO.accountType.in(param.getAccountTypeList()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(param.getConditions(), AccountSnapshotDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
       //增加扩展字段查询条件end
        return ExpressionUtils.allOf(predicates);
    }


    public List<AccountSnapshotDO> selectAccountSnapshotByParam(AccountSnapshotParam queryParam) {
        JPAQuery<AccountSnapshotDO> query = jpaQueryFactory.select(qAccountSnapshotDO).from(qAccountSnapshotDO);

        if (StringUtils.isNotEmpty(queryParam.getAccountCode())) {
            query.where(qAccountSnapshotDO.accountCode.eq(queryParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getAccountCodeList())) {
            query.where(qAccountSnapshotDO.accountCode.in(queryParam.getAccountCodeList()));
        }
        if (Objects.nonNull(queryParam.getRepairTime())) {
            query.where(qAccountSnapshotDO.snapshotTime.goe(queryParam.getRepairTime()));
        }
        return query.fetch();
    }
}
