package com.elitesland.fin.repo.invoice;

import com.elitesland.fin.application.facade.param.invoice.PaymentOrderParam;
import com.elitesland.fin.application.facade.vo.invoice.PaymentOrderPageRespVo;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.entity.invoice.PaymentOrderFiledDo;
import com.elitesland.fin.entity.invoice.QPaymentOrderFiledDo;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class PaymentOrderFiledRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPaymentOrderFiledDo qPaymentOrderFiledDo = QPaymentOrderFiledDo.paymentOrderFiledDo;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;
    private final QBean<PaymentOrderPageRespVo> appList = Projections.bean(
            PaymentOrderPageRespVo.class,
            qPayOrderDO.id,
            qPayOrderDO.payOrderNo,
            qPayOrderDO.suppName,
            qPayOrderDO.suppCode,
            qPayOrderDO.payTypeCode,
            qPayOrderDO.payTypeName,
            qPayOrderDO.orderState,
            qPayOrderDO.realPayAmt,
            qPayOrderDO.totalAmt,
            qPayOrderDO.ouCode,
            qPayOrderDO.ouId,
            qPaymentOrderFiledDo.shopCode,
            qPaymentOrderFiledDo.shopName,
            qPaymentOrderFiledDo.masId,
            qPayOrderDO.payTypeCode,
            qPayOrderDO.currCode,
            qPaymentOrderFiledDo.applyFile,
            qPayOrderDO.orderState,
            qPayOrderDO.realPayAmt,
            qPayOrderDO.apDate,
            qPayOrderDO.remark,
            qPayOrderDO.creator,
            qPayOrderDO.createTime
    );

    public long countPaymentOrderRpc(PaymentOrderParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(qPayOrderDO.count())
                .from(qPayOrderDO).leftJoin(qPaymentOrderFiledDo).on(qPayOrderDO.id.eq(qPaymentOrderFiledDo.masId));
        ;
        jpaQuery.where(this.whereRecOrderRpc(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<PaymentOrderPageRespVo> queryPaymentOrderPrc(PaymentOrderParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(appList)
                .from(qPayOrderDO).leftJoin(qPaymentOrderFiledDo).on(qPayOrderDO.id.eq(qPaymentOrderFiledDo.masId));
        // jpaQuery.where(franchiseeDO.franchiseeCode.eq(paramVO.getFranchiseeCode()));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, qPayOrderDO);
        jpaQuery.where(this.whereRecOrderRpc(paramVO));

        return jpaQuery.fetch();
    }

    public PaymentOrderPageRespVo queryPaymentOrderPrcDetail(Long id) {
        var jpaQuery = jpaQueryFactory.select(appList)
                .from(qPayOrderDO).leftJoin(qPaymentOrderFiledDo).on(qPayOrderDO.id.eq(qPaymentOrderFiledDo.masId)).where(qPayOrderDO.id.eq(id));
        // jpaQuery.where(franchiseeDO.franchiseeCode.eq(paramVO.getFranchiseeCode()));
        return jpaQuery.fetchOne();
    }

    private Predicate whereRecOrderRpc(PaymentOrderParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotEmpty(paramVO.getPayOrderNo())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getPayOrderNo());
            predicates.add(qPayOrderDO.payOrderNo.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getShopName())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getShopName());
            predicates.add(qPaymentOrderFiledDo.shopName.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getPayTypeCode())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getPayTypeCode());
            predicates.add(qPayOrderDO.payTypeCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getShopCode())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getShopCode());
            predicates.add(qPaymentOrderFiledDo.shopCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getOrderState())) {
            predicates.add(qPayOrderDO.orderState.eq(paramVO.getOrderState()));
        }
//        //是否过滤当前登录人待办
//        if (Boolean.TRUE.equals(paramVO.getIsMyTodo())) {
//            Long currentUserId = FosIamUtil.currentUser().getId();
//            predicates.add(franchiseeApplyDO.flowCurrentNodeHandlerUserIds.like("%`" + currentUserId + "`%"));
//        }
//        if (StringUtils.isNotEmpty(paramVO.getRecTypeCode())) {
//            predicates.add(qRecOrderDO.recTypeCode.eq(paramVO.getRecTypeCode()));
//        }
        if (StringUtils.isNotEmpty(paramVO.getCreator())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getCreator());
            predicates.add(qPayOrderDO.creator.like(likeStr));
        }
        if (!ObjectUtils.isEmpty(paramVO.getApDateStart())) {
            predicates.add(qPayOrderDO.apDate.after(paramVO.getApDateStart())
                    .or(qPayOrderDO.apDate.after(paramVO.getApDateStart())));
        }
        if (!ObjectUtils.isEmpty(paramVO.getApDateEnd())) {
            predicates.add(qPayOrderDO.apDate.before(paramVO.getApDateEnd())
                    .or(qPayOrderDO.apDate.before(paramVO.getApDateEnd())));
        }
        if (StringUtils.isNotEmpty(paramVO.getSuppCode())) {
            predicates.add(qPayOrderDO.suppCode.eq(paramVO.getSuppCode()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getSuppName())) {
            predicates.add(qPayOrderDO.suppName.in(paramVO.getSuppName()));
        }
//        if(StringUtils.isNotEmpty(paramVO.getFlowStatus())){
//            predicates.add(franchiseeApplyDO.flowStatus.eq(FlowStatus.valueOf(paramVO.getFlowStatus())));
//        }
//        // 加盟商权限过滤
//        Optional<FranchiseeUserDO> franchiseeUserDO = fosFranchiseeUtil.currentFranchiseeUser();
//        if (franchiseeUserDO.isPresent()) {
//            predicates.add(franchiseeApplyDO.franchiseeId.eq(franchiseeUserDO.get().getFranchiseeId()));
//        } else {
//            if (Arrays.asList(FosConstant.CT,FosConstant.KA).contains(FosIamUtil.getUserOrgCode())) {
//                predicates.add(franchiseeApplyDO.channelType.eq(FosIamUtil.getUserOrgCode()));
//            }
//            if (FosIamUtil.isEmployee()) {
//                predicates.add(franchiseeApplyDO.empUserId.eq(FosIamUtil.currentUser().getId()));
//            }
//        }
        return ExpressionUtils.allOf(predicates);
    }

    /**
     * 根据主表id修改数据
     */
    public Long masIdUpdateFiled(PaymentOrderFiledDo rec) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qPaymentOrderFiledDo.id.eq(rec.getMasId()));
        var update = jpaQueryFactory.update(qPaymentOrderFiledDo)
                .set(qPaymentOrderFiledDo.shopName, rec.getShopName())
                .set(qPaymentOrderFiledDo.shopCode, rec.getShopCode())
              //  .set(qPaymentOrderFiledDo.applyFile, rec.getApplyFile())
                .where(ExpressionUtils.allOf(predicates));
        return update.execute();
    }
}
