/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.fin.application.facade.dto.mq.InvoiceApplyProcessMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.utils.BeanUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceApplyProcessListener
implements MessageQueueListener<InvoiceApplyProcessMqMessageDTO> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceApplyProcessListener.class);
    private final RedLockUtils redLockUtils;
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepo saleInvDtlRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"invoice_apply_process"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(@NotBlank String s, @NotNull InvoiceApplyProcessMqMessageDTO messageDTO) {
        log.info("\u5f00\u7968\u4e2d\u53d1\u7968\u5904\u7406\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        RedissonRedLock redLock = null;
        try {
            redLock = this.redLockUtils.getRedLock("invoice_apply_process" + messageDTO.getBusinessKey());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u7a0e\u53f7\u4e3a:{}\u7684\u53d1\u7968\u7533\u8bf7\u5355\u5df2\u5728\u5904\u7406\u4e2d,\u83b7\u53d6\u9501\u5931\u8d25", (Object)messageDTO.getBusinessKey());
                return;
            }
            List<Long> idList = messageDTO.getIdList();
            List allByInvState = this.saleInvRepo.findAllById(idList);
            if (CollectionUtil.isEmpty((Collection)allByInvState)) {
                log.error("\u672a\u627e\u5230\u5f85\u5f00\u7968\u7684\u53d1\u7968\u7533\u8bf7\u5355");
                return;
            }
            allByInvState = allByInvState.stream().filter(saleInvDO -> {
                if (!Objects.equals(saleInvDO.getInvState(), UdcEnum.INV_STATE_WAIT.getValueCode())) {
                    log.error("\u53d1\u7968\u7533\u8bf7\u5355:{},\u4e0d\u5904\u4e8e\u5f85\u5f00\u7968\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406", (Object)saleInvDO.getApplyNo());
                    return false;
                }
                return true;
            }).sorted((o1, o2) -> o2.getTotalAmt().compareTo(o1.getTotalAmt())).collect(Collectors.toList());
            List<Long> masIdList = allByInvState.stream().map(BaseModel::getId).toList();
            List<SaleInvDtlDO> allByMasIdIn = this.saleInvDtlRepo.findAllByMasIdIn(masIdList);
            Map<Long, List<SaleInvDtlDO>> saleInvDtlMap = allByMasIdIn.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
            ArrayList<InvoiceApplySaveParam> invoiceApplySaveParamList = new ArrayList<InvoiceApplySaveParam>();
            for (SaleInvDO record : allByInvState) {
                List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(record.getId());
                InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
                BeanUtils.copyProperties((Object)record, (Object)saveParam, (String[])new String[0]);
                if (saleInvDtlDOS != null && !saleInvDtlDOS.isEmpty()) {
                    List<InvoiceDetailSaveParam> detailList = saleInvDtlDOS.stream().map(detail -> {
                        InvoiceDetailSaveParam invoiceDetail = new InvoiceDetailSaveParam();
                        BeanUtils.copyProperties((Object)detail, (Object)invoiceDetail, (String[])new String[0]);
                        return invoiceDetail;
                    }).toList();
                    saveParam.setDetails(detailList);
                }
                invoiceApplySaveParamList.add(saveParam);
            }
            if (CollectionUtil.isNotEmpty(invoiceApplySaveParamList)) {
                log.info("\u627e\u5230 {} \u6761\u5f85\u5f00\u7533\u8bf7\u53d1\u7968\uff0c\u5f00\u59cb\u63d0\u4ea4...", (Object)invoiceApplySaveParamList.size());
                for (InvoiceApplySaveParam value : invoiceApplySaveParamList) {
                    if (value.getTotalAmt().compareTo(BigDecimal.ZERO) < 0) continue;
                    this.abstractInvoiceSaveService.invoiceApply(value, null);
                }
            }
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38,\u53d1\u7968\u6d41\u6c34\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u5f00\u7968\u4e2d\u53d1\u7968\u786e\u8ba4\u5b8c\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
    }

    public InvoiceApplyProcessListener(RedLockUtils redLockUtils, AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService, SaleInvRepo saleInvRepo, SaleInvDtlRepo saleInvDtlRepo) {
        this.redLockUtils = redLockUtils;
        this.abstractInvoiceSaveService = abstractInvoiceSaveService;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepo = saleInvDtlRepo;
    }
}

