/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.entity.invoice.TaxAccountMappingDO;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyRequest;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceResultParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedPayload;
import com.elitesland.fin.infinity.aisino.vo.param.BlueInvoiceResultParam;
import com.elitesland.fin.infinity.aisino.vo.param.InvoiceRequestSerialNoParam;
import com.elitesland.fin.infinity.aisino.vo.param.ItemDetail;
import com.elitesland.fin.infinity.aisino.vo.param.RedInvoiceOpenParam;
import com.elitesland.fin.infinity.aisino.vo.resp.InvoiceRedInitialRespVO;
import com.elitesland.fin.infr.repo.saleinv.TaxAccountMappingDORepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AisinoPayloadService {
    private static final Logger log = LoggerFactory.getLogger(AisinoPayloadService.class);
    @Autowired
    private UdcProvider sysUdcService;
    @Autowired
    private TaxAccountMappingDORepo taxAccountMappingDORepo;
    @Value(value="${aisino.encrypt.key:Y#Y*B!PC}")
    private String encryptKey;
    @Value(value="${aisino.api.appid:YYBPC}")
    private String appId;

    public AisinoCoverParamPayload assembleAisinoPayload(String param, String taxNo) {
        log.info("assembleAisinoPayload: {}", (Object)param);
        TaxAccountMappingDO byTaxNo = this.taxAccountMappingDORepo.findByTaxNo(taxNo);
        if (byTaxNo == null) {
            throw new BusinessException("\u7a0e\u53f7" + taxNo + "\u672a\u914d\u7f6e\u5f00\u7968\u8d26\u6237");
        }
        String accountNo = byTaxNo.getAccountNo();
        return AisinoCoverParamPayload.builder().APPID(this.appId).USERNAME(accountNo).NSRSBH(taxNo).DATA(this.encrypt(param)).build();
    }

    public AisinoBlueInvoiceApplyParam blueInvoiceApplyInitial(InvoiceApplySaveParam saveParam, SaleInvdDtlDO saleInvdDtlDO) {
        AisinoBlueInvoiceApplyParam row = new AisinoBlueInvoiceApplyParam();
        if (saleInvdDtlDO != null) {
            row.setFPQQLSH(saleInvdDtlDO.getFlowNo());
        } else {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String randomStr = timestamp.substring(timestamp.length() - 5);
            String randomFiveDigits = String.format("%05d", (int)(Math.random() * 100000.0));
            row.setFPQQLSH(saveParam.getSaleTaxNo() + randomStr + randomFiveDigits);
        }
        AisinoBlueInvoiceApplyRequest request = new AisinoBlueInvoiceApplyRequest();
        request.setDJH(saveParam.getApplyNo());
        request.setGMFMC(saveParam.getCustInvTitle());
        request.setGMFSH(saveParam.getCustTaxNo() == null ? "" : saveParam.getCustTaxNo());
        request.setGMFYH(saveParam.getInvBankNo());
        request.setGMFYHZH(saveParam.getBankAccount());
        if (Objects.equals(saveParam.getInvTitleType(), "ENTERPRISE")) {
            request.setGMFRYXZ("1");
        } else if (Objects.equals(saveParam.getInvTitleType(), "PERSON")) {
            request.setGMFRYXZ("0");
        }
        request.setKPLX("0");
        if (saveParam.getInvType().equals("81")) {
            request.setFPZLDM("01");
        } else if (saveParam.getInvType().equals("82")) {
            request.setFPZLDM("02");
        }
        request.setJSHJ(this.scale(saveParam.getTotalAmt()));
        List<InvoiceDetailSaveParam> details = saveParam.getDetails();
        LocalDateTime minDate = null;
        LocalDateTime maxDate = null;
        for (InvoiceDetailSaveParam detail : details) {
            if (detail.getSourceTime() == null) continue;
            if (minDate == null || detail.getSourceTime().isBefore(minDate)) {
                minDate = detail.getSourceTime();
            }
            if (maxDate != null && !detail.getSourceTime().isAfter(maxDate)) continue;
            maxDate = detail.getSourceTime();
        }
        Object dateRange = "";
        if (minDate != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            dateRange = minDate.format(formatter) + "-" + maxDate.format(formatter);
        }
        request.setBZ((String)dateRange + saveParam.getInvCustName());
        request.setXHFKHH(saveParam.getSaleBank() == null ? "" : saveParam.getSaleBank());
        request.setXHFYHZH(saveParam.getSaleBankAcc() == null ? "" : saveParam.getSaleBankAcc());
        request.setGMFZRRBS("N");
        request.setSFZSGMFYHZH("N");
        request.setSFZSXSFYHZH("N");
        request.setSFZSGMFDZDH("N");
        request.setSFZSXSFDZDH("N");
        BigDecimal netAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        Map taxTypeUdc = this.sysUdcService.getValueMapByUdcCode("yst-supp", "TAX_CLASS_CODE");
        ArrayList<ItemDetail> itemDetails = new ArrayList<ItemDetail>();
        int lineNo = 1;
        int discountLineNo = 1;
        for (InvoiceDetailSaveParam detail : saveParam.getDetails()) {
            netAmt = netAmt.add(detail.getExclTaxAmt());
            taxAmt = taxAmt.add(detail.getTaxAmt());
            ItemDetail drow = new ItemDetail();
            drow.setXH(Integer.toString(lineNo));
            drow.setSPBM(detail.getTaxCode().length() < 19 ? detail.getTaxCode().concat(StringUtils.repeat((String)"0", (int)(19 - detail.getTaxCode().length()))) : detail.getTaxCode());
            drow.setSPMC(detail.getItemName());
            String taxTypeName = (String)taxTypeUdc.get(detail.getTaxCode());
            if (taxTypeName != null) {
                drow.setSPJM("*" + taxTypeName + "*");
            }
            drow.setGGXH(detail.getItemType());
            drow.setJLDW(detail.getUom());
            drow.setSLV(detail.getTaxRate().setScale(2, RoundingMode.HALF_UP).toString());
            drow.setSL(Objects.isNull(detail.getQty()) ? "" : detail.getQty().toString());
            drow.setDJ(Objects.isNull(detail.getPrice()) ? "" : this.scale(detail.getPrice()));
            drow.setJE(Objects.isNull(detail.getTotalAmt()) ? "" : this.scale(detail.getTotalAmt()));
            drow.setSE(Objects.isNull(detail.getTaxAmt()) ? "" : this.scale(detail.getTaxAmt()));
            drow.setKCE("");
            if (detail.getLineNature() != null) {
                drow.setHXZ(detail.getLineNature());
            } else if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                drow.setHXZ("2");
                drow.setZKBH(Integer.toString(discountLineNo));
            } else {
                drow.setHXZ("0");
            }
            drow.setHSBZ("1");
            itemDetails.add(drow);
            ++lineNo;
            if (detail.getDiscountAmt() == null || detail.getDiscountAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            ItemDetail discountRow = new ItemDetail();
            discountRow.setXH(Integer.toString(lineNo));
            discountRow.setSPBM(detail.getTaxCode().length() < 19 ? detail.getTaxCode().concat(StringUtils.repeat((String)"0", (int)(19 - detail.getTaxCode().length()))) : detail.getTaxCode());
            discountRow.setSPMC(detail.getItemName() + "-\u9500\u552e\u6298\u6263");
            if (taxTypeName != null) {
                discountRow.setSPJM("*" + taxTypeName + "*");
            }
            discountRow.setGGXH("");
            discountRow.setJLDW("");
            discountRow.setSLV(detail.getTaxRate().setScale(2, RoundingMode.HALF_UP).toString());
            discountRow.setZKBH(Integer.toString(discountLineNo));
            discountRow.setSL("");
            discountRow.setDJ("");
            discountRow.setJE(this.scale(detail.getDiscountAmt().negate()));
            BigDecimal discountExclTaxAmt = detail.getDiscountAmt().divide(detail.getTaxRate().add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
            BigDecimal discountTaxAmt = detail.getDiscountAmt().subtract(discountExclTaxAmt);
            discountRow.setSE(this.scale(discountTaxAmt.negate()));
            netAmt = netAmt.add(discountExclTaxAmt.negate());
            taxAmt = taxAmt.add(discountTaxAmt.negate());
            discountRow.setKCE("");
            discountRow.setHXZ("1");
            discountRow.setHSBZ("1");
            itemDetails.add(discountRow);
            ++lineNo;
            ++discountLineNo;
        }
        request.setHJJE(this.scale(netAmt));
        request.setHJSE(this.scale(taxAmt));
        request.setMXLIST(itemDetails);
        row.setREQUEST(request);
        return row;
    }

    public InvoiceRequestSerialNoParam getInvoiceInfoByFlowNo(SaleInvdDtlDO saleInvdDtlDO) {
        InvoiceRequestSerialNoParam param = new InvoiceRequestSerialNoParam();
        param.setFPQQLSH(saleInvdDtlDO.getFlowNo());
        return param;
    }

    public String convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoRedPayload row = new AisinoRedPayload();
        row.setLZFPQDHM(saveParam.getInvNo());
        row.setGMFNSRSBH(saveParam.getCustTaxNo() == null ? "" : saveParam.getCustTaxNo());
        row.setXSFNSRSBH(saveParam.getSaleTaxNo() == null ? "" : saveParam.getSaleTaxNo());
        row.setLZKPRQ(saveParam.getInvDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        row.setKPFNSRSBH(saveParam.getSaleTaxNo() == null ? "" : saveParam.getSaleTaxNo());
        row.setGJBQ("1");
        row.setTDYSLXDM("");
        row.setFPLXDM(saveParam.getInvType());
        row.setLZFPHM("");
        row.setLZFPDM("");
        row.setFPLYDM("2");
        return JSON.toJSONString((Object)row);
    }

    public String convertRedSave(InvoiceRedInitialRespVO saveParam) {
        saveParam.setCHYYDM("01");
        return JSON.toJSONString((Object)saveParam);
    }

    public String convertRedOpen(AisinoRedInvoiceParam saveParam) {
        RedInvoiceOpenParam row = new RedInvoiceOpenParam();
        row.setUUID(saveParam.getUUID());
        row.setFPQQLSH(saveParam.getFPQQLSH());
        row.setYFPHM(saveParam.getYFPHM());
        row.setHZFPXXQRDBH(saveParam.getHZFPXXQRDBH());
        row.setSFZZFP(saveParam.getSFZZFP());
        row.setZZFPHM(saveParam.getZZFPHM());
        row.setFPDM(saveParam.getFPDM());
        row.setFPZLDM(saveParam.getFPZLDM());
        return JSON.toJSONString((Object)row);
    }

    public String getBlueResult(String applyNo, LocalDateTime applyTime) {
        AisinoBlueInvoiceResultParam result = new AisinoBlueInvoiceResultParam();
        result.setFPHM(applyNo);
        result.setKPRQ(applyTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        return JSON.toJSONString((Object)result);
    }

    public String getBase64Result(String applyNo, LocalDateTime applyTime) {
        BlueInvoiceResultParam result = new BlueInvoiceResultParam();
        result.setFPHM(applyNo);
        result.setKPRQ(applyTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        result.setWJGS("PDF");
        return JSON.toJSONString((Object)result);
    }

    public String encrypt(String row) {
        return this.getEncryptedData(JSONObject.toJSONString((Object)row));
    }

    private String getEncryptedData(String row) {
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), this.encryptKey);
        if (encryptedBytes == null) {
            log.error("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:{}", (Object)row);
            throw new BusinessException("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    public <T> T decrypt(String row, Class<T> clazz) {
        log.info("\u89e3\u5bc6\u5165\u53c2:{},\u7c7b\u540d:{}", (Object)row, clazz);
        String encryptedData = this.getDecryptedData(row);
        log.info("\u89e3\u5bc6\u6570\u636e:{}", (Object)encryptedData);
        return (T)JSON.parseObject((String)encryptedData, clazz);
    }

    private String getDecryptedData(String encryptedData) {
        byte[] encryptedBytes = InvoiceIssueUtil.parseHexStr2Byte(encryptedData);
        if (encryptedBytes == null) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData);
        }
        try {
            byte[] decryptedBytes = InvoiceIssueUtil.decrypt(encryptedBytes, this.encryptKey);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25,\u89e3\u5bc6\u8fc7\u7a0b\u5f02\u5e38\uff0c\u52a0\u5bc6\u6570\u636e:" + encryptedData, e);
        }
    }

    private String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }
}

