package com.elitesland.fin.application.convert.expense;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigRespVO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.param.expense.ExpRuleDtlRpcVO;
import com.elitesland.fin.param.expense.ExpRuleQueryRpcRespVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author Mark
 * @date 2024/08/13 14:23
 */
@Mapper(config = BaseMapperConfig.class)
public interface ExpRuleConfigConvert {
    ExpRuleConfigConvert INSTANCE = Mappers.getMapper(ExpRuleConfigConvert.class);

    ExpRuleConfigDO param2DO(ExpRuleConfigSaveParam source);

    ExpRuleConfigQueryVO do2VO(ExpRuleConfigDO source);

    List<ExpRuleConfigQueryVO> do2VOBatch(List<ExpRuleConfigDO> sourceList);

    ExpRuleConfigDTO do2DTO(ExpRuleConfigDO source);

    ExpRuleConfigRespVO do2RespVO(ExpRuleConfigDO source);

    List<ExpRuleQueryRpcRespVO> vo2RpcVoBatch(List<ExpRuleConfigQueryVO> sourceList);

    @Mapping(source = "expRuleConfigDtlDTOList", target = "expRuleConfigDtlDTOList")
    ExpRuleQueryRpcRespVO vo2RpcVo(ExpRuleConfigQueryVO source);

    ExpRuleDtlRpcVO vo2RpcVoDtl(ExpRuleConfigDtlDTO source);
}
