package com.elitesland.fin.domain.expense;

import cn.hutool.core.lang.Assert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package
 * @date 2022/4/11 13:10
 */
@Data
public class ExpType {

    private Long id;

    private String itemCode;

    private String itemName;

    private String expTypeCode;

    private String expTypeName;

    private Boolean enableFlag;

    @ApiModelProperty(value = "备注")
    private String remark;

    private List<ExpTypeDtl> dtlList;

    public void checkNotNull() {
        Assert.notEmpty(this.expTypeName, "费用类型名称不能为空");
        Assert.notEmpty(this.expTypeCode, "费用类型编码不能为空");
        Assert.notEmpty(this.itemCode, "商品编码不能为空");
        Assert.notEmpty(this.itemName, "商品名称不能为空");
    }

    public void setDefaultValue() {
        this.enableFlag = true;
    }
}
