/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDtlDO;
import com.elitesland.fin.domain.entity.paymentperiod.QReceiptPaymentAgreementDO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderExcelDTO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ArOrderDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;
    private final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;

    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != arOrderDtlPageParam.getMasId()) {
            predicates.add(this.qArOrderDtlDO.masId.eq((Object)arOrderDtlPageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderDtlPageParam.getMasIds())) {
            predicates.add(this.qArOrderDtlDO.masId.in(arOrderDtlPageParam.getMasIds()));
        }
        predicates.add(this.qArOrderDtlDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(ArOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        arOrderDtlPageParam.setPaging(query);
        arOrderDtlPageParam.fillOrders(query, this.qArOrderDtlDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qArOrderDtlDO.id, this.qArOrderDtlDO.sourceNo, this.qArOrderDtlDO.masId, this.qArOrderDtlDO.sourceLine, this.qArOrderDtlDO.itemId, this.qArOrderDtlDO.itemCode, this.qArOrderDtlDO.itemName, this.qArOrderDtlDO.itemType, this.qArOrderDtlDO.smallCateCode, this.qArOrderDtlDO.smallCateName, this.qArOrderDtlDO.uom, this.qArOrderDtlDO.uomName, this.qArOrderDtlDO.qty, this.qArOrderDtlDO.exclTaxPrice, this.qArOrderDtlDO.price, this.qArOrderDtlDO.taxRate, this.qArOrderDtlDO.totalAmt, this.qArOrderDtlDO.exclTaxAmt, this.qArOrderDtlDO.taxAmt, this.qArOrderDtlDO.totalCurAmt, this.qArOrderDtlDO.exclTaxCurAmt, this.qArOrderDtlDO.taxCurAmt, this.qArOrderDtlDO.remark, this.qArOrderDtlDO.buCode, this.qArOrderDtlDO.buId, this.qArOrderDtlDO.buName, this.qArOrderDtlDO.expensesType, this.qArOrderDtlDO.relateId, this.qArOrderDtlDO.es11, this.qArOrderDtlDO.es12, this.qArOrderDtlDO.es13, this.qArOrderDtlDO.es14, this.qArOrderDtlDO.es15, this.qArOrderDtlDO.es16, this.qArOrderDtlDO.es17, this.qArOrderDtlDO.es18, this.qArOrderDtlDO.es19, this.qArOrderDtlDO.es20, this.qArOrderDtlDO.es21, this.qArOrderDtlDO.es22, this.qArOrderDtlDO.es23, this.qArOrderDtlDO.es24, this.qArOrderDtlDO.docType, this.qArOrderDtlDO.docType2, this.qArOrderDtlDO.docCls, this.qArOrderDtlDO.verAmt, this.qArOrderDtlDO.unVerAmt, this.qArOrderDtlDO.applyVerAmTing, this.qArOrderDtlDO.protocolCode, this.qArOrderDtlDO.invIoId})).from((EntityPath)this.qArOrderDtlDO);
    }

    public List<Long> findBySourceId(String sourceId) {
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderDtlDO.masId).from((EntityPath)this.qArOrderDtlDO)).where((Predicate)this.qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<Long> findBySourceNoList(List<String> sourceNoList) {
        if (CollectionUtil.isEmpty(sourceNoList)) {
            return Collections.EMPTY_LIST;
        }
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderDtlDO.masId).from((EntityPath)this.qArOrderDtlDO)).where((Predicate)this.qArOrderDtlDO.sourceNo.in(sourceNoList))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<Long> findUnverBySourceId(ArOrderPageParam arOrderPageParam) {
        String sourceId = arOrderPageParam.getSourceNoDtl();
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)sourceId)) {
            predicates.add(this.qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"));
        }
        predicates.add(this.qArOrderDtlDO.deleteFlag.eq((Object)0));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderDtlDO.masId).from((EntityPath)this.qArOrderDtlDO)).where(ExpressionUtils.allOf(predicates));
        jpaQuery.groupBy(this.qArOrderDtlDO.masId);
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getWriteOfFAmtCon())) {
            if ("GT0".equals(arOrderPageParam.getWriteOfFAmtCon())) {
                jpaQuery.having((Predicate)this.qArOrderDtlDO.unVerAmt.sum().gt((Number)BigDecimal.ZERO));
            } else if ("LT0".equals(arOrderPageParam.getWriteOfFAmtCon())) {
                jpaQuery.having((Predicate)this.qArOrderDtlDO.unVerAmt.sum().lt((Number)BigDecimal.ZERO));
            }
        } else {
            jpaQuery.having((Predicate)this.qArOrderDtlDO.unVerAmt.sum().ne((Object)BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<BigDecimal> countByMasId(Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qArOrderDtlDO.qty).from((EntityPath)this.qArOrderDtlDO)).where((Predicate)this.qArOrderDtlDO.masId.eq((Object)id))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
    }

    public Long del(List<Long> ids) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qArOrderDtlDO).set(this.qArOrderDtlDO.deleteFlag, (Object)1).where(new Predicate[]{this.qArOrderDtlDO.masId.in(ids)}).execute();
        return res;
    }

    public void delByMasId(List<Long> id) {
        this.jpaQueryFactory.delete((EntityPath)this.qArOrderDtlDO).where(new Predicate[]{this.qArOrderDtlDO.masId.in(id)}).execute();
    }

    @SysCodeProc
    public List<ArOrderDtlDTO> listByMisId(Long masId) {
        List res = ((JPAQuery)((JPAQuery)this.select(ArOrderDtlDTO.class).where((Predicate)this.qArOrderDtlDO.masId.eq((Object)masId))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    @SysCodeProc
    public List<ArOrderDtlDTO> listByMasIds(Collection<Long> ids) {
        List res = ((JPAQuery)((JPAQuery)this.select(ArOrderDtlDTO.class).where((Predicate)this.qArOrderDtlDO.masId.in(ids))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<ArOrderDtlDTO> listByIds(List<Long> ids) {
        List res = ((JPAQuery)((JPAQuery)this.select(ArOrderDtlDTO.class).where((Predicate)this.qArOrderDtlDO.id.in(ids))).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<ArOrderDtlHandleDTO> selectVerState() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ArOrderDtlHandleDTO.class, (Expression[])new Expression[]{this.qArOrderDtlDO.masId, this.qArOrderDtlDO.verAmt.sum().as("verAmtSum"), this.qArOrderDtlDO.applyVerAmTing.sum().as("applyVerAmTingSum"), this.qArOrderDtlDO.unVerAmt.sum().as("unVerAmtSum")})).from((EntityPath)this.qArOrderDtlDO)).where((Predicate)this.qArOrderDtlDO.deleteFlag.eq((Object)0).or((Predicate)this.qArOrderDtlDO.deleteFlag.isNull()))).groupBy(this.qArOrderDtlDO.masId);
        return jpaQuery.fetch();
    }

    public Long countExportArOrder(ArOrderPageParam arOrderPageParam) {
        Predicate customFieldPredicate;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qArOrderDtlDO.count()).from((EntityPath)this.qArOrderDtlDO)).leftJoin((EntityPath)this.qArOrderDO)).on((Predicate)this.qArOrderDtlDO.masId.eq(this.qArOrderDO.id));
        List<Predicate> predicates = this.pageWhere(arOrderPageParam);
        if (StrUtil.isNotBlank((CharSequence)arOrderPageParam.getSourceNoDtl())) {
            predicates.add((Predicate)this.qArOrderDtlDO.sourceNo.like("%" + arOrderPageParam.getSourceNoDtl() + "%"));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qArOrderDtlDO.sourceNo.in(arOrderPageParam.getDtlSourceNoList()));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add((Predicate)this.qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)arOrderPageParam.getConditions(), ArOrderDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        BusinessSecurityUtil.where(jpaQuery, ArOrderDO.class);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchCount();
    }

    public List<ArOrderExcelDTO> exportArOrder(ArOrderPageParam arOrderPageParam) {
        QReceiptPaymentAgreementDO receiptPaymentAgreementDO = QReceiptPaymentAgreementDO.receiptPaymentAgreementDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ArOrderExcelDTO.class, (Expression[])new Expression[]{this.qArOrderDO.id, this.qArOrderDO.sourceNo, this.qArOrderDO.ouCode, this.qArOrderDO.ouId, this.qArOrderDO.ouName, this.qArOrderDO.arTypeId, this.qArOrderDO.arTypeName, this.qArOrderDO.arTypeCode, this.qArOrderDO.currCode, this.qArOrderDO.currName, this.qArOrderDO.operator, this.qArOrderDO.operUserId, this.qArOrderDO.totalAmt, this.qArOrderDO.totalCurAmt, this.qArOrderDO.buDate, this.qArOrderDO.auditUserId, this.qArOrderDO.auditUser, this.qArOrderDO.auditDate, this.qArOrderDO.orderState, this.qArOrderDO.exchangeRate, this.qArOrderDO.initFlag, this.qArOrderDO.taxFlag, this.qArOrderDO.createTime, this.qArOrderDO.exclTaxAmt, this.qArOrderDO.taxAmt, this.qArOrderDO.arOrderNo, this.qArOrderDO.creator, this.qArOrderDO.createMode, this.qArOrderDO.remark, this.qArOrderDO.exclTaxCurAmt, this.qArOrderDO.verState, this.qArOrderDO.verAmt, this.qArOrderDO.orgId, this.qArOrderDO.orgCode, this.qArOrderDO.orgName, this.qArOrderDO.saleUserId, this.qArOrderDO.saleUser, this.qArOrderDO.custName, this.qArOrderDO.custId, this.qArOrderDO.custCode, this.qArOrderDO.docType, this.qArOrderDO.docType2, this.qArOrderDO.docCls, this.qArOrderDO.approvedTime, this.qArOrderDO.submitTime, this.qArOrderDO.settlementType, this.qArOrderDO.redSourceNo, this.qArOrderDO.redSourceId, this.qArOrderDO.redState, this.qArOrderDO.inOutCust, this.qArOrderDO.protocolCode, this.qArOrderDO.relevanceOuCode, this.qArOrderDtlDO.sourceNo.as("detailSourceNo"), this.qArOrderDtlDO.sourceLine, this.qArOrderDtlDO.itemCode, this.qArOrderDtlDO.itemId, this.qArOrderDtlDO.itemName, this.qArOrderDtlDO.smallCateCode, this.qArOrderDtlDO.smallCateName, this.qArOrderDtlDO.uom, this.qArOrderDtlDO.uomName, this.qArOrderDtlDO.qty, this.qArOrderDtlDO.exclTaxPrice, this.qArOrderDtlDO.price, this.qArOrderDtlDO.taxRate, this.qArOrderDtlDO.totalAmt.as("detailTotalAmt"), this.qArOrderDtlDO.exclTaxAmt.as("detailExclTaxAmt"), this.qArOrderDtlDO.taxAmt.as("detailTaxAmt"), this.qArOrderDtlDO.verAmt, this.qArOrderDtlDO.unVerAmt, this.qArOrderDtlDO.applyVerAmTing.as("applyVerAmt"), this.qArOrderDtlDO.protocolCode, receiptPaymentAgreementDO.protocolName})).from((EntityPath)this.qArOrderDtlDO)).leftJoin((EntityPath)this.qArOrderDO)).on((Predicate)this.qArOrderDtlDO.masId.eq(this.qArOrderDO.id))).leftJoin((EntityPath)receiptPaymentAgreementDO)).on((Predicate)this.qArOrderDtlDO.protocolCode.eq((Expression)receiptPaymentAgreementDO.protocolCode).and((Predicate)receiptPaymentAgreementDO.protocolType.eq((Object)UdcEnum.AGREEMENT_PROTOCOL_TYPE_RECEIPT.getValueCode())));
        List<Predicate> predicates = this.pageWhere(arOrderPageParam);
        if (StrUtil.isNotBlank((CharSequence)arOrderPageParam.getSourceNoDtl())) {
            predicates.add((Predicate)this.qArOrderDtlDO.sourceNo.like("%" + arOrderPageParam.getSourceNoDtl() + "%"));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qArOrderDtlDO.sourceNo.in(arOrderPageParam.getDtlSourceNoList()));
        }
        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add((Predicate)this.qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        arOrderPageParam.setPaging(jpaQuery);
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)arOrderPageParam.getConditions(), ArOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        BusinessSecurityUtil.where(jpaQuery, ArOrderDO.class);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(new OrderSpecifier[]{this.qArOrderDO.id.desc(), this.qArOrderDtlDO.id.desc()});
        return jpaQuery.fetch();
    }

    private List<Predicate> pageWhere(ArOrderPageParam arOrderPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.checkParam(arOrderPageParam, predicates);
        if (Objects.nonNull(arOrderPageParam.getEs2())) {
            predicates.add((Predicate)this.qArOrderDO.es2.like("%" + arOrderPageParam.getEs2() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCreateMode())) {
            predicates.add((Predicate)this.qArOrderDO.createMode.eq((Object)arOrderPageParam.getCreateMode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCreateModeList())) {
            predicates.add((Predicate)this.qArOrderDO.createMode.in(arOrderPageParam.getCreateModeList()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedState())) {
            predicates.add((Predicate)this.qArOrderDO.redState.eq(arOrderPageParam.getRedState()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedSourceNo())) {
            predicates.add((Predicate)this.qArOrderDO.redSourceNo.like("%" + arOrderPageParam.getRedSourceNo() + "%"));
        }
        if (null != arOrderPageParam.getInitFlag()) {
            predicates.add((Predicate)this.qArOrderDO.initFlag.eq(arOrderPageParam.getInitFlag()));
        }
        if (arOrderPageParam.getProposedStatus() != null) {
            predicates.add((Predicate)this.qArOrderDO.proposedStatus.eq((Object)arOrderPageParam.getProposedStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getProtocolCode())) {
            predicates.add((Predicate)this.qArOrderDO.protocolCode.eq((Object)arOrderPageParam.getProtocolCode()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getProtocolCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.protocolCode.in(arOrderPageParam.getProtocolCodeList()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getRelevanceOuCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.relevanceOuCode.in(arOrderPageParam.getRelevanceOuCodeList()));
        }
        this.buildPredicates(arOrderPageParam, predicates);
        predicates.add((Predicate)this.qArOrderDO.deleteFlag.eq((Object)0));
        return predicates;
    }

    private void buildPredicates(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOrgCode())) {
            predicates.add((Predicate)this.qArOrderDO.orgCode.eq((Object)arOrderPageParam.getOrgCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrgCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.orgCode.in(arOrderPageParam.getOrgCodeList()));
        }
        if (null != arOrderPageParam.getOrgId()) {
            predicates.add((Predicate)this.qArOrderDO.orgId.eq((Object)arOrderPageParam.getOrgId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrgIdList())) {
            predicates.add((Predicate)this.qArOrderDO.orgId.in(arOrderPageParam.getOrgIdList()));
        }
        if (null != arOrderPageParam.getCustId()) {
            predicates.add((Predicate)this.qArOrderDO.custId.eq((Object)arOrderPageParam.getCustId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCustIdList())) {
            predicates.add((Predicate)this.qArOrderDO.custId.in(arOrderPageParam.getCustIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCustName())) {
            predicates.add((Predicate)this.qArOrderDO.custName.like("%" + arOrderPageParam.getCustName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCustCode())) {
            predicates.add((Predicate)this.qArOrderDO.custCode.eq((Object)arOrderPageParam.getCustCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCustCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.custCode.in(arOrderPageParam.getCustCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrCode())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.eq((Object)arOrderPageParam.getCurrCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getSaleUser())) {
            predicates.add((Predicate)this.qArOrderDO.saleUser.like("%" + arOrderPageParam.getSaleUser() + "%"));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getSaleUserList())) {
            predicates.add((Predicate)this.qArOrderDO.saleUser.in(arOrderPageParam.getSaleUserList()));
        }
        if (null != arOrderPageParam.getBuId()) {
            predicates.add((Predicate)this.qArOrderDO.buId.eq((Object)arOrderPageParam.getBuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getBuIdList())) {
            predicates.add((Predicate)this.qArOrderDO.buId.in(arOrderPageParam.getBuIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getBuCode())) {
            predicates.add((Predicate)this.qArOrderDO.buCode.eq((Object)arOrderPageParam.getBuCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getBuCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.buCode.in(arOrderPageParam.getBuCodeList()));
        }
        if (null != arOrderPageParam.getAuditDateStart() && null != arOrderPageParam.getAuditDateEnd()) {
            predicates.add((Predicate)this.qArOrderDO.auditDate.between((Comparable)arOrderPageParam.getAuditDateStart(), (Comparable)arOrderPageParam.getAuditDateEnd()));
        }
        if (ObjectUtil.isNotNull((Object)arOrderPageParam.getOuId())) {
            predicates.add((Predicate)this.qArOrderDO.ouId.eq((Object)arOrderPageParam.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())) {
            predicates.add((Predicate)this.qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOuCode())) {
            predicates.add((Predicate)this.qArOrderDO.ouCode.eq((Object)arOrderPageParam.getOuCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.ouCode.in(arOrderPageParam.getOuCodeList()));
        }
    }

    private void checkParam(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (null != arOrderPageParam.getOuId()) {
            predicates.add((Predicate)this.qArOrderDO.ouId.eq((Object)arOrderPageParam.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())) {
            predicates.add((Predicate)this.qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrCode())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.eq((Object)arOrderPageParam.getCurrCode()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())) {
            predicates.add((Predicate)this.qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCurrName())) {
            predicates.add((Predicate)this.qArOrderDO.currName.eq((Object)arOrderPageParam.getCurrName()));
        }
        if (null != arOrderPageParam.getBuDateStart() && null != arOrderPageParam.getBuDateEnd()) {
            predicates.add((Predicate)this.qArOrderDO.buDate.between((Comparable)arOrderPageParam.getBuDateStart(), (Comparable)arOrderPageParam.getBuDateEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qArOrderDO.sourceNo.like("%" + arOrderPageParam.getSourceNo() + "%"));
        }
        if (null != arOrderPageParam.getArTypeId()) {
            predicates.add((Predicate)this.qArOrderDO.arTypeId.eq((Object)arOrderPageParam.getArTypeId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getArTypeIdList())) {
            predicates.add((Predicate)this.qArOrderDO.arTypeId.in(arOrderPageParam.getArTypeIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOrderState())) {
            predicates.add((Predicate)this.qArOrderDO.orderState.eq((Object)arOrderPageParam.getOrderState()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getOrderStateList())) {
            predicates.add((Predicate)this.qArOrderDO.orderState.in(arOrderPageParam.getOrderStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getVerState())) {
            predicates.add((Predicate)this.qArOrderDO.verState.eq((Object)arOrderPageParam.getVerState()));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getVerStateList())) {
            predicates.add((Predicate)this.qArOrderDO.verState.in(arOrderPageParam.getVerStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getArOrderNo())) {
            predicates.add((Predicate)this.qArOrderDO.arOrderNo.like("%" + arOrderPageParam.getArOrderNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(arOrderPageParam.getArOrderNoList())) {
            predicates.add((Predicate)this.qArOrderDO.arOrderNo.in(arOrderPageParam.getArOrderNoList()));
        }
        if (null != arOrderPageParam.getTotalAmtStart()) {
            predicates.add((Predicate)this.qArOrderDO.totalAmt.goe((Number)arOrderPageParam.getTotalAmtStart()));
        }
        if (null != arOrderPageParam.getTotalAmtEnd()) {
            predicates.add((Predicate)this.qArOrderDO.totalAmt.loe((Number)arOrderPageParam.getTotalAmtEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getOperator())) {
            predicates.add((Predicate)this.qArOrderDO.operator.like("%" + arOrderPageParam.getOperator() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getCreator())) {
            predicates.add((Predicate)this.qArOrderDO.creator.like("%" + arOrderPageParam.getCreator() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)arOrderPageParam.getAuditUser())) {
            predicates.add((Predicate)this.qArOrderDO.auditUser.like("%" + arOrderPageParam.getAuditUser() + "%"));
        }
    }

    public ArOrderDtlRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

