package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_account_period_line")
@org.hibernate.annotations.Table(appliesTo = "fin_account_period_line", comment = "会计期间明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccountPeriodLineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "period_style",columnDefinition = "varchar(20)  comment '期间格式'")
    private String periodStyle;

    @Column(name = "year", columnDefinition = "varchar(2) comment '年份'")
    private String year;

    @Column(name = "quarter", columnDefinition = "varchar(2) comment '季度'")
    private String quarter;

    @Column(name = "month", columnDefinition = "varchar(2) comment '月份'")
    private String month;

    @Column(name = "active_start_time", columnDefinition = "datetime(6) comment '起始有效日期'")
    private LocalDateTime activeStartTime;

    @Column(name = "active_end_time", columnDefinition = "datetime(6) comment '终止有效日期'")
    private LocalDateTime activeEndTime;
}
