package com.elitesland.fin.infr.dto.payorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:49
 */
@Data
public class PayOrderDtlDTO implements Serializable {

    private static final long serialVersionUID = -5770927779461246581L;
    private Long id;

    private Long masId;

    @ApiModelProperty("付款方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payType;
    private String payTypeName;

    private String payBank;

    private String payAccount;

    private String recBank;

    private String recAccount;

    private String sourceNo;

    private Integer sourceLine;

    private Long sourceId;

    private Long sourceLineId;

    private BigDecimal realPayAmt;

    private BigDecimal realPayCurAmt;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    private Long buId;

    private String buName;

    private String buCode;

    private String remark;

    private BigDecimal verAmt;

    private BigDecimal unVerAmt;

    private BigDecimal applyVerAmTing;

}
